/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.jbossweb;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.gravity.AbstractGravityServlet;
import org.granite.gravity.jbossweb.EventUtil;
import org.granite.gravity.tomcat.CometIO;
import org.granite.logging.Logger;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;

public abstract class AbstractHttpEventServlet
extends AbstractGravityServlet
implements HttpEventServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AbstractHttpEventServlet.class);
    private boolean longPollingTimeoutSupported = true;

    public abstract CometIO createCometIO();

    public abstract boolean handleRequest(HttpEvent var1, InputStream var2) throws IOException, ServletException;

    public abstract boolean handleEnd(HttpEvent var1) throws IOException, ServletException;

    public abstract boolean handleError(HttpEvent var1) throws IOException, ServletException;

    public void event(HttpEvent event) throws IOException, ServletException {
        if (!EventUtil.isValid(event)) {
            log.error("JBossWeb sent an invalid HttpEvent: %s", event.getType());
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("%s: %s/%s", event.getType(), event.getHttpServletRequest(), event.getHttpServletResponse());
        }
        if (event.getType() == HttpEvent.EventType.BEGIN) {
            this.begin(event);
        } else if (event.getType() == HttpEvent.EventType.READ) {
            this.read(event);
        } else if (event.getType() == HttpEvent.EventType.END) {
            this.end(event);
        } else if (event.getType() == HttpEvent.EventType.ERROR || event.getType() == HttpEvent.EventType.EOF || event.getType() == HttpEvent.EventType.TIMEOUT) {
            this.error(event);
        } else {
            throw new ServletException("Unknown HttpEvent type: " + event.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void begin(HttpEvent event) throws IOException, ServletException {
        boolean close = true;
        try {
            if (this.longPollingTimeoutSupported) {
                try {
                    event.setTimeout((int)this.getLongPollingTimeout());
                }
                catch (Exception e) {
                    this.longPollingTimeoutSupported = false;
                }
            }
            HttpServletRequest request = event.getHttpServletRequest();
            CometIO io = this.createCometIO();
            io.readFully((InputStream)request.getInputStream());
            close = this.handleRequest(event, io.getInputStream());
            if (!close) return;
        }
        catch (Throwable throwable) {
            if (!close) throw throwable;
            try {
                event.close();
                throw throwable;
            }
            catch (Exception e) {
                log.debug(e, "Could not close event: %s", EventUtil.toString(event));
            }
            throw throwable;
        }
        try {
            event.close();
            return;
        }
        catch (Exception e) {
            log.debug(e, "Could not close event: %s", EventUtil.toString(event));
        }
    }

    protected void read(HttpEvent event) {
        throw new RuntimeException("Unsupported operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void end(HttpEvent event) throws IOException, ServletException {
        boolean close = true;
        try {
            close = this.handleEnd(event);
            if (!close) return;
        }
        catch (Throwable throwable) {
            if (!close) throw throwable;
            try {
                event.close();
                throw throwable;
            }
            catch (Exception e) {
                log.debug(e, "Could not close event: %s", EventUtil.toString(event));
            }
            throw throwable;
        }
        try {
            event.close();
            return;
        }
        catch (Exception e) {
            log.debug(e, "Could not close event: %s", EventUtil.toString(event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void error(HttpEvent event) throws IOException, ServletException {
        boolean close = true;
        try {
            close = this.handleError(event);
            if (!close) return;
        }
        catch (Throwable throwable) {
            if (!close) throw throwable;
            try {
                event.close();
                throw throwable;
            }
            catch (Exception e) {
                log.debug(e, "Could not close event: %s", EventUtil.toString(event));
            }
            throw throwable;
        }
        try {
            event.close();
            return;
        }
        catch (Exception e) {
            log.debug(e, "Could not close event: %s", EventUtil.toString(event));
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        throw new ServletException("Not in a valid Comet configuration (use an APR or NIO connector)");
    }
}

