/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.jetty8;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.LinkedList;
import javax.servlet.ServletContext;
import org.eclipse.jetty.websocket.WebSocket;
import org.granite.context.GraniteContext;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.jetty8.JettyWebSocketChannelFactory;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.ServletGraniteContext;

public class JettyWebSocketChannel
extends AbstractChannel
implements WebSocket,
WebSocket.OnBinaryMessage {
    private static final Logger log = Logger.getLogger(JettyWebSocketChannel.class);
    private ServletContext servletContext;
    private WebSocket.Connection connection;
    private Message connectAckMessage;

    public JettyWebSocketChannel(Gravity gravity, String id, JettyWebSocketChannelFactory factory, ServletContext servletContext, String clientType) {
        super(gravity, id, factory, clientType);
        this.servletContext = servletContext;
    }

    public void setConnectAckMessage(Message ackMessage) {
        this.connectAckMessage = ackMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(WebSocket.Connection connection) {
        this.connection = connection;
        this.connection.setMaxIdleTime((int)this.getGravity().getGravityConfig().getChannelIdleTimeoutMillis());
        log.debug("WebSocket connection onOpen", new Object[0]);
        if (this.connectAckMessage == null) {
            return;
        }
        try {
            this.initializeRequest();
            byte[] resultData = JettyWebSocketChannel.serialize(this.getGravity(), new Message[]{this.connectAckMessage});
            connection.sendMessage(resultData, 0, resultData.length);
            this.connectAckMessage = null;
        }
        catch (IOException e) {
            log.error(e, "Could not send connect acknowledge", new Object[0]);
        }
        finally {
            JettyWebSocketChannel.cleanupRequest();
        }
    }

    public void onClose(int closeCode, String message) {
        log.debug("WebSocket connection onClose %d, %s", closeCode, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(byte[] data, int offset, int length) {
        log.debug("WebSocket connection onMessage %d", data.length);
        try {
            this.initializeRequest();
            Message[] messages = JettyWebSocketChannel.deserialize(this.getGravity(), data, offset, length);
            log.debug(">> [AMF3 REQUESTS] %s", new Object[]{messages});
            Message[] responses = null;
            boolean accessed = false;
            int responseIndex = 0;
            for (int i = 0; i < messages.length; ++i) {
                Message message = messages[i];
                Message response = this.getGravity().handleMessage(this.getFactory(), message);
                String channelId = (String)message.getClientId();
                if (!accessed) {
                    accessed = this.getGravity().access(channelId);
                }
                if (response == null) continue;
                responses = responses == null ? new Message[1] : Arrays.copyOf(responses, responses.length + 1);
                responses[responseIndex++] = response;
            }
            if (responses != null && responses.length > 0) {
                log.debug("<< [AMF3 RESPONSES] %s", new Object[]{responses});
                byte[] resultData = JettyWebSocketChannel.serialize(this.getGravity(), responses);
                this.connection.sendMessage(resultData, 0, resultData.length);
            }
        }
        catch (ClassNotFoundException e) {
            log.error(e, "Could not handle incoming message data", new Object[0]);
        }
        catch (IOException e) {
            log.error(e, "Could not handle incoming message data", new Object[0]);
        }
        finally {
            JettyWebSocketChannel.cleanupRequest();
        }
    }

    private Gravity initializeRequest() {
        ServletGraniteContext.createThreadInstance(this.gravity.getGraniteConfig(), this.gravity.getServicesConfig(), this.servletContext, this.sessionId, this.clientType);
        return this.gravity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Message[] deserialize(Gravity gravity, byte[] data, int offset, int length) throws ClassNotFoundException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset, length);
        try {
            ObjectInput amf3Deserializer = gravity.getGraniteConfig().newAMF3Deserializer(is);
            Object[] objects = (Object[])amf3Deserializer.readObject();
            Message[] messages = new Message[objects.length];
            System.arraycopy(objects, 0, messages, 0, objects.length);
            Message[] messageArray = messages;
            return messageArray;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serialize(Gravity gravity, Message[] messages) throws IOException {
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream(200 * messages.length);
            ObjectOutput amf3Serializer = gravity.getGraniteConfig().newAMF3Serializer(os);
            amf3Serializer.writeObject(messages);
            os.flush();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private static void cleanupRequest() {
        GraniteContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runReceived(AsyncHttpContext asyncHttpContext) {
        LinkedList messages = null;
        ByteArrayOutputStream os = null;
        try {
            this.receivedQueueLock.lock();
            try {
                if (this.receivedQueue.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                messages = this.receivedQueue;
                this.receivedQueue = new LinkedList();
            }
            finally {
                this.receivedQueueLock.unlock();
            }
            if (this.connection == null || !this.connection.isOpen()) {
                boolean bl = false;
                return bl;
            }
            AsyncMessage[] messagesArray = new AsyncMessage[messages.size()];
            int i = 0;
            for (AsyncMessage message : messages) {
                messagesArray[i++] = message;
            }
            Gravity gravity = this.getGravity();
            ServletGraniteContext context = ServletGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), this.servletContext, this.sessionId, this.clientType);
            os = new ByteArrayOutputStream(500);
            ObjectOutput amf3Serializer = context.getGraniteConfig().newAMF3Serializer(os);
            log.debug("<< [MESSAGES for channel=%s] %s", this, messagesArray);
            amf3Serializer.writeObject(messagesArray);
            this.connection.sendMessage(os.toByteArray(), 0, os.size());
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.warn(e, "Could not send messages to channel: %s (retrying later)", this);
            GravityConfig gravityConfig = this.getGravity().getGravityConfig();
            if (gravityConfig.isRetryOnError()) {
                this.receivedQueueLock.lock();
                try {
                    if (this.receivedQueue.size() + messages.size() > gravityConfig.getMaxMessagesQueuedPerChannel()) {
                        log.warn("Channel %s has reached its maximum queue capacity %s (throwing %s messages)", this, gravityConfig.getMaxMessagesQueuedPerChannel(), messages.size());
                    } else {
                        this.receivedQueue.addAll(0, messages);
                    }
                }
                finally {
                    this.receivedQueueLock.unlock();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {}
            }
            try {
                GraniteContext.release();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            this.close();
        }
    }

    public void close() {
        if (this.connection != null) {
            this.connection.close(1000, "Channel closed");
            this.connection = null;
        }
    }

    protected boolean hasAsyncHttpContext() {
        return true;
    }

    protected void releaseAsyncHttpContext(AsyncHttpContext context) {
    }

    protected AsyncHttpContext acquireAsyncHttpContext() {
        return null;
    }
}

