/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.selector;

import flex.messaging.messages.Message;
import java.io.IOException;
import javax.jms.JMSException;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.command.Response;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.selector.SelectorParser;
import org.apache.activemq.state.CommandVisitor;
import org.granite.gravity.selector.MessageSelector;

public class ActiveMQMessageSelector
implements MessageSelector {
    private BooleanExpression expression;

    public ActiveMQMessageSelector(String selector) {
        try {
            this.expression = SelectorParser.parse((String)selector);
        }
        catch (Exception e) {
            throw new RuntimeException("ActiveMQ SelectorParser error " + selector, e);
        }
    }

    public boolean accept(Message message) {
        try {
            MessageEvaluationContext context = new MessageEvaluationContext();
            MessageAdapter ma = new MessageAdapter(message);
            context.setMessageReference((MessageReference)ma);
            return this.expression.matches(context);
        }
        catch (Exception e) {
            throw new RuntimeException("ActiveMQ selector accept error " + message, e);
        }
    }

    private static class MessageAdapter
    extends org.apache.activemq.command.Message {
        private Message message = null;

        public MessageAdapter(Message message) {
            this.message = message;
        }

        public Object getProperty(String name) throws IOException {
            return this.message.getHeader(name);
        }

        public org.apache.activemq.command.Message copy() {
            return null;
        }

        public Response visit(CommandVisitor visitor) throws Exception {
            return null;
        }

        public byte getDataStructureType() {
            return 0;
        }

        public void clearBody() throws JMSException {
        }
    }
}

