/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.servlet3;

import flex.messaging.messages.CommandMessage;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.AbstractGravityServlet;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.servlet3.AsyncChannelFactory;
import org.granite.logging.Logger;

public class AsyncChannel
extends AbstractChannel {
    private static final Logger log = Logger.getLogger(AsyncChannel.class);
    private final AtomicReference<AsyncContext> asyncContext = new AtomicReference();

    public AsyncChannel(Gravity gravity, String id, AsyncChannelFactory factory, String clientType) {
        super(gravity, id, factory, clientType);
    }

    public void setAsyncContext(AsyncContext asyncContext) {
        AsyncContext previousAsyncContext;
        if (log.isDebugEnabled()) {
            log.debug("Channel: %s got new asyncContext: %s", this.getId(), asyncContext);
        }
        if ((previousAsyncContext = this.asyncContext.getAndSet(asyncContext)) != null) {
            if (asyncContext != null) {
                log.warn("Got a new non null asyncContext %s while current asyncContext %s isn't null", asyncContext, this.asyncContext.get());
            }
            if (previousAsyncContext != asyncContext) {
                try {
                    previousAsyncContext.complete();
                }
                catch (Exception e) {
                    log.debug(e, "Error while closing asyncContext", new Object[0]);
                }
            }
        }
        if (asyncContext != null) {
            this.queueReceiver();
        }
    }

    protected boolean hasAsyncHttpContext() {
        return this.asyncContext.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AsyncHttpContext acquireAsyncHttpContext() {
        CommandMessage requestMessage;
        HttpServletResponse response;
        HttpServletRequest request;
        AsyncHttpContext context;
        AsyncContext asyncContext;
        block19: {
            block18: {
                asyncContext = this.asyncContext.getAndSet(null);
                if (asyncContext == null) {
                    return null;
                }
                context = null;
                try {
                    request = null;
                    response = null;
                    try {
                        request = (HttpServletRequest)asyncContext.getRequest();
                        response = (HttpServletResponse)asyncContext.getResponse();
                    }
                    catch (Exception e) {
                        log.warn("Illegal asyncContext: %s", asyncContext);
                        AsyncHttpContext asyncHttpContext = null;
                        if (context != null) return asyncHttpContext;
                        try {
                            asyncContext.complete();
                            return asyncHttpContext;
                        }
                        catch (Exception e2) {
                            log.debug(e2, "Error while closing asyncContext: %s", asyncContext);
                        }
                        return asyncHttpContext;
                    }
                }
                catch (Throwable throwable) {
                    if (context != null) throw throwable;
                    try {
                        asyncContext.complete();
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.debug(e, "Error while closing asyncContext: %s", asyncContext);
                    }
                    throw throwable;
                }
                if (request != null && response != null) break block18;
                log.warn("Illegal asyncContext (request or response is null): %s", asyncContext);
                AsyncHttpContext e = null;
                if (context != null) return e;
                try {
                    asyncContext.complete();
                    return e;
                }
                catch (Exception e3) {
                    log.debug(e3, "Error while closing asyncContext: %s", asyncContext);
                }
                return e;
            }
            requestMessage = AbstractGravityServlet.getConnectMessage(request);
            if (requestMessage != null) break block19;
            log.warn("No request message while running channel: %s", this.getId());
            AsyncHttpContext asyncHttpContext = null;
            if (context != null) return asyncHttpContext;
            try {
                asyncContext.complete();
                return asyncHttpContext;
            }
            catch (Exception e) {
                log.debug(e, "Error while closing asyncContext: %s", asyncContext);
            }
            return asyncHttpContext;
        }
        context = new AsyncHttpContext(request, response, requestMessage, asyncContext);
        if (context != null) return context;
        try {
            asyncContext.complete();
            return context;
        }
        catch (Exception e) {
            log.debug(e, "Error while closing asyncContext: %s", asyncContext);
        }
        return context;
    }

    protected void releaseAsyncHttpContext(AsyncHttpContext context) {
        try {
            if (context != null && context.getObject() != null) {
                ((AsyncContext)context.getObject()).complete();
            }
        }
        catch (Exception e) {
            log.warn(e, "Could not release asyncContext for channel: %s", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            this.close();
        }
    }

    public void close() {
        AsyncContext asyncContext = this.asyncContext.getAndSet(null);
        if (asyncContext != null) {
            try {
                asyncContext.complete();
            }
            catch (Exception e) {
                log.debug(e, "Could not close asyncContext: %s for channel: %s", asyncContext, this);
            }
        }
    }
}

