/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.servlet3;

import flex.messaging.messages.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.config.GraniteConfigListener;
import org.granite.gravity.AbstractGravityServlet;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityManager;
import org.granite.gravity.servlet3.AsyncChannel;
import org.granite.gravity.servlet3.AsyncChannelFactory;
import org.granite.gravity.servlet3.AsyncRequestListener;
import org.granite.gravity.servlet3.JMFAsyncChannelFactory;
import org.granite.logging.Logger;
import org.granite.messaging.jmf.JMFDeserializer;
import org.granite.messaging.jmf.JMFSerializer;
import org.granite.messaging.jmf.SharedContext;
import org.granite.util.ContentType;
import org.granite.util.UUIDUtil;

public class GravityAsyncServlet
extends AbstractGravityServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(GravityAsyncServlet.class);
    protected SharedContext jmfSharedContext = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.jmfSharedContext = GraniteConfigListener.getSharedContext(config.getServletContext());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.isAsyncSupported()) {
            throw new ServletException("Asynchronous requests are not supported with this servlet. Please check your web.xml");
        }
        if (request.isAsyncStarted()) {
            throw new ServletException("Gravity Servlet3 implementation doesn't support dispatch(...) mode");
        }
        Gravity gravity = GravityManager.getGravity(this.getServletContext());
        AsyncChannelFactory channelFactory = this.newAsyncChannelFactory(gravity, request.getContentType());
        try {
            this.initializeRequest(gravity, request, response);
            Message[] amf3Requests = this.deserialize(gravity, request);
            log.debug(">> [AMF3 REQUESTS] %s", new Object[]{amf3Requests});
            Message[] amf3Responses = null;
            boolean accessed = false;
            for (int i = 0; i < amf3Requests.length; ++i) {
                Message amf3Request = amf3Requests[i];
                Message amf3Response = gravity.handleMessage(channelFactory, amf3Request);
                String channelId = (String)amf3Request.getClientId();
                if (!accessed) {
                    accessed = gravity.access(channelId);
                }
                if (amf3Response == null) {
                    if (amf3Requests.length > 1) {
                        throw new IllegalArgumentException("Only one connect request is allowed on tunnel.");
                    }
                    AsyncChannel channel = gravity.getChannel(channelFactory, channelId);
                    if (channel == null) {
                        throw new NullPointerException("No channel on tunnel connect");
                    }
                    if (!channel.runReceived(new AsyncHttpContext(request, response, amf3Request))) {
                        GravityAsyncServlet.setConnectMessage(request, amf3Request);
                        AsyncContext asyncContext = request.startAsync();
                        asyncContext.setTimeout(this.getLongPollingTimeout());
                        try {
                            asyncContext.addListener((AsyncListener)new AsyncRequestListener(channel));
                            channel.setAsyncContext(asyncContext);
                        }
                        catch (Exception e) {
                            log.error(e, "Error while setting async context. Closing context...", new Object[0]);
                            asyncContext.complete();
                        }
                    }
                    return;
                }
                if (amf3Responses == null) {
                    amf3Responses = new Message[amf3Requests.length];
                }
                amf3Responses[i] = amf3Response;
            }
            log.debug("<< [AMF3 RESPONSES] %s", new Object[]{amf3Responses});
            this.serialize(gravity, response, amf3Responses, request.getContentType());
        }
        catch (IOException e) {
            log.error(e, "Gravity message error", new Object[0]);
            throw e;
        }
        catch (Exception e) {
            log.error(e, "Gravity message error", new Object[0]);
            throw new ServletException((Throwable)e);
        }
        finally {
            this.cleanupRequest(request);
        }
    }

    public void destroy() {
        this.jmfSharedContext = null;
        super.destroy();
    }

    protected AsyncChannelFactory newAsyncChannelFactory(Gravity gravity, String contentType) throws ServletException {
        if (ContentType.JMF_AMF.mimeType().equals(contentType)) {
            if (this.jmfSharedContext == null) {
                throw GraniteConfigListener.newSharedContextNotInitializedException();
            }
            return new JMFAsyncChannelFactory(gravity, this.jmfSharedContext);
        }
        return new AsyncChannelFactory(gravity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message[] deserialize(Gravity gravity, HttpServletRequest request) throws ClassNotFoundException, IOException, ServletException {
        if (ContentType.JMF_AMF.mimeType().equals(request.getContentType())) {
            ServletInputStream is = request.getInputStream();
            try {
                Message[] messageArray = this.deserializeJMFAMF(gravity, request, (InputStream)is);
                return messageArray;
            }
            finally {
                is.close();
            }
        }
        return super.deserialize(gravity, request);
    }

    protected Message[] deserialize(Gravity gravity, HttpServletRequest request, InputStream is) throws ClassNotFoundException, IOException, ServletException {
        if (ContentType.JMF_AMF.mimeType().equals(request.getContentType())) {
            return this.deserializeJMFAMF(gravity, request, is);
        }
        return super.deserialize(gravity, request, is);
    }

    protected Message[] deserializeJMFAMF(Gravity gravity, HttpServletRequest request, InputStream is) throws ClassNotFoundException, IOException, ServletException {
        if (this.jmfSharedContext == null) {
            throw GraniteConfigListener.newSharedContextNotInitializedException();
        }
        JMFDeserializer deserializer = new JMFDeserializer(is, this.jmfSharedContext);
        return (Message[])deserializer.readObject();
    }

    protected void serialize(Gravity gravity, HttpServletResponse response, Message[] messages, String contentType) throws IOException, ServletException {
        if (ContentType.JMF_AMF.mimeType().equals(contentType)) {
            this.serializeJMFAMF(gravity, response, messages);
        } else {
            super.serialize(gravity, response, messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serializeJMFAMF(Gravity gravity, HttpServletResponse response, Message[] messages) throws IOException, ServletException {
        if (this.jmfSharedContext == null) {
            throw GraniteConfigListener.newSharedContextNotInitializedException();
        }
        OutputStream os = null;
        try {
            String dsId = null;
            for (Message message : messages) {
                if (!"nil".equals(message.getHeader("DSId"))) continue;
                if (dsId == null) {
                    dsId = UUIDUtil.randomUUID();
                }
                message.getHeaders().put("DSId", dsId);
            }
            response.setStatus(200);
            response.setContentType(ContentType.JMF_AMF.mimeType());
            response.setDateHeader("Expire", 0L);
            response.setHeader("Cache-Control", "no-store");
            os = response.getOutputStream();
            JMFSerializer serializer = new JMFSerializer(os, this.jmfSharedContext);
            serializer.writeObject(messages);
            os.flush();
            response.flushBuffer();
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }
}

