/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.tomcat;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.util.Base64;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WebSocketServlet;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.res.StringManager;
import org.granite.context.GraniteContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityManager;
import org.granite.gravity.GravityServletUtil;
import org.granite.gravity.tomcat.TomcatWebSocketChannel;
import org.granite.gravity.tomcat.TomcatWebSocketChannelFactory;
import org.granite.gravity.tomcat.WsHttpServletRequestWrapper;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.ServletGraniteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatWebSocketServlet
extends WebSocketServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(TomcatWebSocketServlet.class);
    private static final byte[] WS_ACCEPT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(B2CConverter.ISO_8859_1);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.websocket");
    private final Queue<MessageDigest> sha1Helpers = new ConcurrentLinkedQueue<MessageDigest>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        GravityServletUtil.init(config);
    }

    protected String selectSubProtocol(List<String> subProtocols) {
        return subProtocols != null && subProtocols.contains("org.granite.gravity") ? "org.granite.gravity" : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamInbound createWebSocketInbound(String protocol, HttpServletRequest request) {
        Gravity gravity = GravityManager.getGravity(this.getServletContext());
        TomcatWebSocketChannelFactory channelFactory = new TomcatWebSocketChannelFactory(gravity, this.getServletContext());
        try {
            String connectMessageId = request.getHeader("connectId") != null ? request.getHeader("connectId") : request.getParameter("connectId");
            String clientId = request.getHeader("GDSClientId") != null ? request.getHeader("GDSClientId") : request.getParameter("GDSClientId");
            String clientType = request.getHeader("GDSClientType") != null ? request.getHeader("GDSClientType") : request.getParameter("GDSClientType");
            String sessionId = null;
            HttpSession session = request.getSession(false);
            if (session != null) {
                ServletGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), this.getServletContext(), session, clientType);
                sessionId = session.getId();
            } else {
                for (int i = 0; i < request.getCookies().length; ++i) {
                    if (!"JSESSIONID".equals(request.getCookies()[i].getName())) continue;
                    sessionId = request.getCookies()[i].getValue();
                    break;
                }
                ServletGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), this.getServletContext(), sessionId, clientType);
            }
            log.info("WebSocket connection started %s clientId %s sessionId %s", protocol, clientId, sessionId);
            CommandMessage pingMessage = new CommandMessage();
            pingMessage.setMessageId(connectMessageId != null ? connectMessageId : "OPEN_CONNECTION");
            pingMessage.setOperation(5);
            if (clientId != null) {
                pingMessage.setClientId(clientId);
            }
            Message ackMessage = gravity.handleMessage(channelFactory, pingMessage);
            TomcatWebSocketChannel channel = gravity.getChannel(channelFactory, (String)ackMessage.getClientId());
            if (!ackMessage.getClientId().equals(clientId)) {
                channel.setConnectAckMessage(ackMessage);
            }
            StreamInbound streamInbound = channel.getStreamInbound();
            return streamInbound;
        }
        finally {
            GraniteContext.release();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String subProtocol = null;
        List extensions = Collections.emptyList();
        if (!this.headerContainsToken(req, "upgrade", "websocket")) {
            resp.sendError(400);
            return;
        }
        if (!this.headerContainsToken(req, "connection", "upgrade")) {
            resp.sendError(400);
            return;
        }
        if (!this.headerContainsToken(req, "sec-websocket-version", "13")) {
            resp.setStatus(426);
            resp.setHeader("Sec-WebSocket-Version", "13");
            return;
        }
        String key = req.getHeader("Sec-WebSocket-Key");
        if (key == null) {
            resp.sendError(400);
            return;
        }
        String origin = req.getHeader("Origin");
        if (!this.verifyOrigin(origin)) {
            resp.sendError(403);
            return;
        }
        List<String> subProtocols = this.getTokensFromHeader(req, "Sec-WebSocket-Protocol");
        if (!subProtocols.isEmpty()) {
            subProtocol = this.selectSubProtocol(subProtocols);
        }
        resp.setHeader("Upgrade", "websocket");
        resp.setHeader("Connection", "upgrade");
        resp.setHeader("Sec-WebSocket-Accept", this.getWebSocketAccept(key));
        if (subProtocol != null) {
            resp.setHeader("Sec-WebSocket-Protocol", subProtocol);
        }
        if (!extensions.isEmpty()) {
            // empty if block
        }
        WsHttpServletRequestWrapper wrapper = new WsHttpServletRequestWrapper(req);
        StreamInbound inbound = this.createWebSocketInbound(subProtocol, wrapper);
        wrapper.invalidate();
        resp.setContentLength(((TomcatWebSocketChannel.MessageInboundImpl)inbound).getAckLength());
        HttpServletRequest inner = req;
        while (inner instanceof ServletRequestWrapper) {
            inner = ((ServletRequestWrapper)inner).getRequest();
        }
        if (inner instanceof RequestFacade) {
            ((RequestFacade)inner).doUpgrade((UpgradeInbound)inbound);
        } else {
            resp.sendError(500, sm.getString("servlet.reqUpgradeFail"));
        }
    }

    private boolean headerContainsToken(HttpServletRequest req, String headerName, String target) {
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                if (!target.equalsIgnoreCase(token.trim())) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getTokensFromHeader(HttpServletRequest req, String headerName) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = header.split(",")) {
                result.add(token.trim());
            }
        }
        return result;
    }

    private String getWebSocketAccept(String key) throws ServletException {
        MessageDigest sha1Helper = this.sha1Helpers.poll();
        if (sha1Helper == null) {
            try {
                sha1Helper = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new ServletException((Throwable)e);
            }
        }
        sha1Helper.reset();
        sha1Helper.update(key.getBytes(B2CConverter.ISO_8859_1));
        String result = Base64.encode((byte[])sha1Helper.digest(WS_ACCEPT));
        this.sha1Helpers.add(sha1Helper);
        return result;
    }
}

