/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util.externalizer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;
import java.util.Map;
import org.granite.messaging.amf.io.util.externalizer.DefaultExternalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapExternalizer
extends DefaultExternalizer {
    @Override
    public int accept(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz) ? 1 : -1;
    }

    @Override
    public void readExternal(Object o, ObjectInput in) throws IOException, ClassNotFoundException, IllegalAccessException {
        Map map = (Map)o;
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            map.put(key, value);
        }
    }

    @Override
    public void writeExternal(Object o, ObjectOutput out) throws IOException, IllegalAccessException {
        LinkedHashMap map = new LinkedHashMap((Map)o);
        out.writeInt(map.size());
        for (Map.Entry entry : map.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }
}

