/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util.instantiator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.granite.messaging.amf.io.util.instantiator.AbstractInstantiator;
import org.granite.messaging.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalInstantiator
extends AbstractInstantiator<BigDecimal> {
    private static final long serialVersionUID = 1L;
    private static final String VALUE = "value";
    private static final List<String> orderedFields;

    @Override
    public List<String> getOrderedFieldNames() {
        return orderedFields;
    }

    @Override
    public BigDecimal newInstance() {
        BigDecimal bigDecimal = null;
        String value = (String)this.get(VALUE);
        if (value != null && value.length() <= 2) {
            if ("0".equals(value)) {
                bigDecimal = BigDecimal.ZERO;
            } else if ("1".equals(value)) {
                bigDecimal = BigDecimal.ONE;
            } else if ("10".equals(value)) {
                bigDecimal = BigDecimal.TEN;
            }
        }
        if (bigDecimal == null) {
            try {
                bigDecimal = new BigDecimal(value);
            }
            catch (NumberFormatException e) {
                throw new ServiceException("Illegal BigDecimal value: " + value, e);
            }
        }
        return bigDecimal;
    }

    static {
        ArrayList<String> of = new ArrayList<String>(1);
        of.add(VALUE);
        orderedFields = Collections.unmodifiableList(of);
    }
}

