/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.JMFDeserializer;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.SharedContext;
import org.granite.messaging.jmf.codec.StandardCodec;

public class JMFDumper
extends JMFDeserializer
implements DumpContext {
    protected static final int DEFAULT_MAX_ARRAY_ELEMENTS = 32;
    protected final PrintStream ps;
    protected final int maxArrayElements;
    protected int indentCount = 0;

    public JMFDumper(InputStream is, SharedContext context, PrintStream ps) {
        this(is, context, ps, 32);
    }

    public JMFDumper(InputStream is, SharedContext context, PrintStream ps, int maxArrayElements) {
        super(is, context);
        this.ps = ps;
        this.maxArrayElements = maxArrayElements;
    }

    public int getMaxArrayElements() {
        return this.maxArrayElements;
    }

    public void dump() throws IOException {
        int parameterizedJmfType;
        while ((parameterizedJmfType = this.inputStream.read()) != -1) {
            int jmfType = this.codecRegistry.extractJmfType(parameterizedJmfType);
            StandardCodec codec = this.codecRegistry.getCodec(jmfType);
            if (codec == null) {
                throw new JMFEncodingException("Unsupported type: " + jmfType);
            }
            codec.dump(this, parameterizedJmfType);
        }
    }

    public void incrIndent(int off) {
        this.indentCount += off;
        if (this.indentCount < 0) {
            this.indentCount = 0;
        }
    }

    public void indentPrint(String message) throws IOException {
        for (int i = 0; i < this.indentCount; ++i) {
            this.ps.print("    ");
        }
        this.ps.print(message);
    }

    public void print(String message) throws IOException {
        this.ps.print(message);
    }

    public void noIndentPrintLn(String message) throws IOException {
        this.ps.println(message);
    }

    public void indentPrintLn(String message) throws IOException {
        for (int i = 0; i < this.indentCount; ++i) {
            this.ps.print("    ");
        }
        this.ps.println(message);
    }
}

