/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntegerStringCodec<T>
extends AbstractStandardCodec<T> {
    protected static final StringTypeHandler JMF_STRING_TYPE_HANDLER = new StringTypeHandler(){

        public int type(IntegerComponents ics, boolean reference) {
            if (reference) {
                return 0x80 | ics.length << 5 | 0xA;
            }
            return ics.length << 5 | 0xA;
        }

        public int indexOrLengthBytesCount(int parameterizedJmfType) {
            return parameterizedJmfType >> 5 & 3;
        }

        public boolean isReference(int parameterizedJmfType) {
            return (parameterizedJmfType & 0x80) != 0;
        }
    };

    protected void writeIntData(OutputContext ctx, IntegerComponents ics) throws IOException {
        int v = ics.value;
        OutputStream os = ctx.getOutputStream();
        switch (ics.length) {
            case 3: {
                os.write(v >> 24);
            }
            case 2: {
                os.write(v >> 16);
            }
            case 1: {
                os.write(v >> 8);
            }
            case 0: {
                os.write(v);
            }
        }
    }

    protected int readIntData(InputContext ctx, int length, boolean opposite) throws IOException {
        int v = 0;
        switch (length) {
            case 3: {
                v |= ctx.safeRead() << 24;
            }
            case 2: {
                v |= ctx.safeRead() << 16;
            }
            case 1: {
                v |= ctx.safeRead() << 8;
            }
            case 0: {
                v |= ctx.safeRead();
            }
        }
        if (opposite) {
            v = -v;
        }
        return v;
    }

    protected IntegerComponents intComponents(int v) {
        int s = 0;
        int l = 3;
        if (v != Integer.MIN_VALUE) {
            if (v < 0) {
                s = 1;
                v = -v;
            }
            l = v <= 65535 ? (v <= 255 ? 0 : 1) : (v <= 0xFFFFFF ? 2 : 3);
        }
        return new IntegerComponents(s, l, v);
    }

    protected void writeString(OutputContext ctx, String v, StringTypeHandler handler) throws IOException {
        if (v == null) {
            throw new NullPointerException("String value cannot be null");
        }
        OutputStream os = ctx.getOutputStream();
        int indexOfStoredString = ctx.indexOfStoredStrings(v);
        if (indexOfStoredString >= 0) {
            IntegerComponents ics = this.intComponents(indexOfStoredString);
            os.write(handler.type(ics, true));
            this.writeIntData(ctx, ics);
        } else {
            ctx.addToStoredStrings(v);
            if (v.length() == 0) {
                os.write(handler.type(IntegerComponents.ZERO, false));
                os.write(0);
            } else {
                byte[] bytes = v.getBytes(UTF8);
                int length = bytes.length;
                IntegerComponents ics = this.intComponents(length);
                os.write(handler.type(ics, false));
                this.writeIntData(ctx, ics);
                os.write(bytes);
            }
        }
    }

    protected String readString(InputContext ctx, int parameterizedJmfType, StringTypeHandler handler) throws IOException {
        int indexOrLength = this.readIntData(ctx, handler.indexOrLengthBytesCount(parameterizedJmfType), false);
        return this.readString(ctx, parameterizedJmfType, indexOrLength, handler);
    }

    protected String readString(InputContext ctx, int parameterizedJmfType, int indexOrLength, StringTypeHandler handler) throws IOException {
        if (handler.isReference(parameterizedJmfType)) {
            return ctx.getSharedString(indexOrLength);
        }
        byte[] bytes = new byte[indexOrLength];
        ctx.safeReadFully(bytes);
        String s = new String(bytes, UTF8);
        ctx.addSharedString(s);
        return s;
    }

    protected static interface StringTypeHandler {
        public int type(IntegerComponents var1, boolean var2);

        public int indexOrLengthBytesCount(int var1);

        public boolean isReference(int var1);
    }

    protected static class IntegerComponents {
        public static final IntegerComponents ZERO = new IntegerComponents(0, 0, 0);
        public final int sign;
        public final int length;
        public final int value;

        public IntegerComponents(int sign, int length, int value) {
            this.sign = sign;
            this.length = length;
            this.value = value;
        }
    }
}

