/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.EnumCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractIntegerStringCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumCodecImpl
extends AbstractIntegerStringCodec<Object>
implements EnumCodec {
    protected static final AbstractIntegerStringCodec.StringTypeHandler TYPE_HANDLER = new AbstractIntegerStringCodec.StringTypeHandler(){

        public int type(AbstractIntegerStringCodec.IntegerComponents ics, boolean reference) {
            return reference ? 0x40 | ics.length << 4 | 2 : ics.length << 4 | 2;
        }

        public int indexOrLengthBytesCount(int parameterizedJmfType) {
            return parameterizedJmfType >> 4 & 3;
        }

        public boolean isReference(int parameterizedJmfType) {
            return (parameterizedJmfType & 0x40) != 0;
        }
    };

    @Override
    public int getObjectType() {
        return 2;
    }

    @Override
    public boolean canEncode(Object v) {
        return v.getClass().isEnum();
    }

    @Override
    public void encode(OutputContext ctx, Object v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        int indexOfStoredObject = ctx.indexOfStoredObjects(v);
        if (indexOfStoredObject >= 0) {
            AbstractIntegerStringCodec.IntegerComponents ics = this.intComponents(indexOfStoredObject);
            os.write(0x80 | ics.length << 4 | 2);
            this.writeIntData(ctx, ics);
        } else {
            ctx.addToStoredObjects(v);
            String className = ctx.getAlias(v.getClass().getName());
            this.writeString(ctx, className, TYPE_HANDLER);
            int ordinal = ((Enum)v).ordinal();
            ctx.getSharedContext().getCodecRegistry().getIntegerCodec().writeVariableInt(ctx, ordinal);
        }
    }

    @Override
    public Object decode(InputContext ctx, int parameterizedJmfType) throws IOException, ClassNotFoundException {
        CodecRegistry codecRegistry = ctx.getSharedContext().getCodecRegistry();
        int jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
        if (jmfType != 2) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        int indexOrLength = this.readIntData(ctx, parameterizedJmfType >> 4 & 3, false);
        Object v = null;
        if ((parameterizedJmfType & 0x80) != 0) {
            v = ctx.getSharedObject(indexOrLength);
        } else {
            String className = this.readString(ctx, parameterizedJmfType, indexOrLength, TYPE_HANDLER);
            className = ctx.getAlias(className);
            Class<?> cls = ctx.getSharedContext().getReflection().loadClass(className);
            int ordinal = codecRegistry.getIntegerCodec().readVariableInt(ctx);
            v = cls.getEnumConstants()[ordinal];
            ctx.addSharedObject(v);
        }
        return v;
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        CodecRegistry codecRegistry = ctx.getSharedContext().getCodecRegistry();
        int jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
        if (jmfType != 2) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        int indexOrLength = this.readIntData(ctx, parameterizedJmfType >> 4 & 3, false);
        if ((parameterizedJmfType & 0x80) != 0) {
            String className = (String)ctx.getSharedObject(indexOrLength);
            ctx.indentPrintLn("<" + className + "@" + indexOrLength + ">");
        } else {
            String className = this.readString(ctx, parameterizedJmfType, indexOrLength, TYPE_HANDLER);
            className = ctx.getAlias(className);
            int ordinal = codecRegistry.getIntegerCodec().readVariableInt(ctx);
            int indexOfStoredObject = ctx.addSharedObject(className);
            ctx.indentPrintLn(className + "@" + indexOfStoredObject + ": <" + ordinal + ">");
        }
    }
}

