/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.StringCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractIntegerStringCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringCodecImpl
extends AbstractIntegerStringCodec<String>
implements StringCodec {
    @Override
    public int getObjectType() {
        return 10;
    }

    @Override
    public Class<?> getObjectClass() {
        return String.class;
    }

    @Override
    public void encode(OutputContext ctx, String v) throws IOException {
        this.writeString(ctx, v, JMF_STRING_TYPE_HANDLER);
    }

    @Override
    public String decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 10) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        return this.readString(ctx, parameterizedJmfType, JMF_STRING_TYPE_HANDLER);
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 10) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        ctx.indentPrintLn(String.class.getName() + ": \"" + this.escape(this.decode(ctx, parameterizedJmfType)) + "\"");
    }
}

