/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import javax.ejb.NoSuchEJBException;
import javax.naming.NamingException;
import org.granite.config.flex.Destination;
import org.granite.logging.Logger;
import org.granite.messaging.service.EjbServiceFactory;
import org.granite.messaging.service.EjbServiceMetadata;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.messaging.service.ServiceInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServiceInvoker
extends ServiceInvoker<EjbServiceFactory> {
    private static final Logger log = Logger.getLogger(EjbServiceInvoker.class);
    public static final String CAPITALIZED_DESTINATION_ID = "{capitalized.destination.id}";
    public static final String DESTINATION_ID = "{destination.id}";
    private final EjbServiceMetadata metadata;

    public EjbServiceInvoker(Destination destination, EjbServiceFactory factory) throws ServiceException {
        super(destination, factory);
        String lookup = factory.getLookup();
        if (destination.getProperties().containsKey("lookup")) {
            lookup = destination.getProperties().get("lookup");
        }
        String name = destination.getId();
        if (lookup != null) {
            name = lookup;
            if (lookup.contains(CAPITALIZED_DESTINATION_ID)) {
                name = lookup.replace(CAPITALIZED_DESTINATION_ID, this.capitalize(destination.getId()));
            }
            if (lookup.contains(DESTINATION_ID)) {
                name = lookup.replace(DESTINATION_ID, destination.getId());
            }
        }
        log.debug(">> New EjbServiceInvoker looking up: %s", name);
        try {
            this.invokee = factory.lookup(name);
        }
        catch (NamingException e) {
            throw new ServiceException("Could not lookup for: " + name, e);
        }
        this.metadata = destination.getScannedClass() != null ? new EjbServiceMetadata(destination.getScannedClass(), this.invokee.getClass()) : new EjbServiceMetadata(destination.getProperties(), this.invokee.getClass());
    }

    public EjbServiceMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    protected void afterInvocationError(ServiceInvocationContext context, Throwable error) {
        if (error instanceof NoSuchEJBException || this.metadata.isStateful() && this.metadata.isRemoveMethod(context.getMethod()) && !this.metadata.getRetainIfException(context.getMethod())) {
            ((EjbServiceFactory)this.factory).removeFromCache(this.destination.getId());
        }
    }

    @Override
    protected Object afterInvocation(ServiceInvocationContext context, Object result) {
        if (this.metadata.isStateful() && this.metadata.isRemoveMethod(context.getMethod())) {
            ((EjbServiceFactory)this.factory).removeFromCache(this.destination.getId());
        }
        return result;
    }

    private String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }
}

