/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.granite.context.GraniteContext;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.AbstractSecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.security.UserRealm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jetty6SecurityService
extends AbstractSecurityService {
    private static final String JETTY6_AUTH = "org.granite.messaging.service.security.Jetty6Auth";

    @Override
    public void configure(Map<String, String> params) {
    }

    @Override
    public void login(Object credentials, String charset) throws SecurityServiceException {
        String[] decoded = this.decodeBase64Credentials(credentials, charset);
        HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = graniteContext.getRequest();
        Request request = httpRequest instanceof Request ? (Request)httpRequest : HttpConnection.getCurrentConnection().getRequest();
        UserRealm realm = request.getUserRealm();
        Principal principal = realm.authenticate(decoded[0], (Object)decoded[1], request);
        if (principal == null) {
            if (request.getSession(false) != null) {
                request.getSession(false).removeAttribute(JETTY6_AUTH);
            }
            throw SecurityServiceException.newInvalidCredentialsException("Wrong username or password");
        }
        request.setAuthType("granite-security");
        request.setUserPrincipal(principal);
        request.getSession().setAttribute(JETTY6_AUTH, (Object)principal);
        this.endLogin(credentials, charset);
    }

    @Override
    public Object authorize(AbstractSecurityContext context) throws Exception {
        this.startAuthorization(context);
        HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = graniteContext.getRequest();
        boolean reauth = false;
        Principal principal = httpRequest.getUserPrincipal();
        if (principal == null) {
            HttpSession session = httpRequest.getSession(false);
            principal = session != null ? (Principal)session.getAttribute(JETTY6_AUTH) : null;
            reauth = true;
        }
        if (principal == null && this.tryRelogin()) {
            principal = httpRequest.getUserPrincipal();
            reauth = false;
        }
        if (principal == null) {
            HttpSession httpSession;
            if (httpRequest.getRequestedSessionId() != null && ((httpSession = httpRequest.getSession(false)) == null || httpRequest.getRequestedSessionId().equals(httpSession.getId()))) {
                throw SecurityServiceException.newSessionExpiredException("Session expired");
            }
            throw SecurityServiceException.newNotLoggedInException("User not logged in");
        }
        Request request = httpRequest instanceof Request ? (Request)httpRequest : HttpConnection.getCurrentConnection().getRequest();
        UserRealm realm = request.getUserRealm();
        if (reauth) {
            realm.reauthenticate(principal);
        }
        if (context.getDestination().isSecured()) {
            boolean accessDenied = true;
            for (String role : context.getDestination().getRoles()) {
                if (!realm.isUserInRole(principal, role)) continue;
                accessDenied = false;
                break;
            }
            if (accessDenied) {
                throw SecurityServiceException.newAccessDeniedException("User not in required role");
            }
            request.setAuthType("granite-security");
            request.setUserPrincipal(principal);
        }
        try {
            return this.endAuthorization(context);
        }
        catch (InvocationTargetException e) {
            for (Throwable t = e; t != null; t = ((Throwable)t).getCause()) {
                if (!(t instanceof SecurityException)) continue;
                throw SecurityServiceException.newAccessDeniedException(t.getMessage());
            }
            throw e;
        }
    }

    @Override
    public void logout() throws SecurityServiceException {
        HttpGraniteContext graniteContext = (HttpGraniteContext)GraniteContext.getCurrentInstance();
        HttpServletRequest httpRequest = graniteContext.getRequest();
        Request request = httpRequest instanceof Request ? (Request)httpRequest : HttpConnection.getCurrentConnection().getRequest();
        UserRealm realm = request.getUserRealm();
        realm.disassociate(httpRequest.getUserPrincipal());
        this.endLogout();
    }
}

