/*
 * Decompiled with CFR 0.152.
 */
package org.granite.osgi.adaptor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.config.GraniteConfig;
import org.granite.config.ServletGraniteConfig;
import org.granite.config.api.Configuration;
import org.granite.config.flex.ServicesConfig;
import org.granite.config.flex.ServletServicesConfig;
import org.granite.logging.Logger;
import org.granite.messaging.amf.AMF0Message;
import org.granite.messaging.amf.io.AMF0Deserializer;
import org.granite.messaging.amf.io.AMF0Serializer;
import org.granite.messaging.amf.process.AMF0MessageProcessor;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.osgi.Activator;
import org.granite.osgi.adaptor.ServiceEventHandler;
import org.granite.osgi.constants.OSGIConstants;
import org.granite.util.ContentType;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.EventHandler;

public class AMFServiceAdaptor
extends HttpServlet {
    private static final long serialVersionUID = 4777538296260511097L;
    private static final Logger log = Logger.getLogger(AMFServiceAdaptor.class);
    private GraniteConfig graniteConfig = null;
    private ServicesConfig servicesConfig = null;
    BundleContext context;

    public AMFServiceAdaptor(BundleContext context) {
        this.context = context;
    }

    public void init(ServletConfig config) {
        try {
            super.init(config);
            Configuration configuration = Activator.getConfigurationService();
            this.getServletContext().setAttribute(ServletGraniteConfig.GRANITE_CONFIG_CONFIGURATION_KEY, (Object)configuration);
            this.graniteConfig = ServletGraniteConfig.loadConfig(this.getServletContext());
            this.servicesConfig = ServletServicesConfig.loadConfig(this.getServletContext());
            Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
            String[] topics = new String[]{OSGIConstants.TOPIC_GDS_ADD_SERVICE, OSGIConstants.TOPIC_GDS_REMOVE_SERVICE};
            ((Dictionary)properties).put("event.topics", topics);
            this.context.registerService(EventHandler.class.getName(), (Object)new ServiceEventHandler(this.servicesConfig), properties);
        }
        catch (ServletException e) {
            log.error(e, "Could initialize OSGi service adaptor", new Object[0]);
        }
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (log.isInfoEnabled()) {
            try {
                HttpGraniteContext context = HttpGraniteContext.createThreadIntance(this.graniteConfig, this.servicesConfig, this.getServletContext(), request, response);
                if (context == null) {
                    throw new ServletException("GraniteContext not Initialized!!");
                }
                if (log.isInfoEnabled()) {
                    log.info(">>>>> Deserializing AMF0 request from..." + request.getRequestURI(), new Object[0]);
                }
                AMF0Deserializer deserializer = new AMF0Deserializer(new DataInputStream((InputStream)request.getInputStream()));
                AMF0Message amf0Request = deserializer.getAMFMessage();
                if (log.isInfoEnabled()) {
                    log.info(">>>>> Processing AMF0 request: " + amf0Request, new Object[0]);
                }
                AMF0Message amf0Response = AMF0MessageProcessor.process(amf0Request);
                if (log.isInfoEnabled()) {
                    log.info("<<<<< Returning AMF0 response: " + amf0Response, new Object[0]);
                }
                response.setContentType(ContentType.AMF.mimeType());
                AMF0Serializer serializer = new AMF0Serializer(new DataOutputStream((OutputStream)response.getOutputStream()));
                serializer.serializeMessage(amf0Response);
                if (log.isInfoEnabled()) {
                    log.info("...End of Processing AMF Request......", new Object[0]);
                }
            }
            catch (Exception e) {
                log.error(e, "Could not handle AMF request", new Object[0]);
                throw new ServletException((Throwable)e);
            }
        }
    }
}

