/*
 * Decompiled with CFR 0.152.
 */
package org.granite.scan;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLoader<S>
implements Iterable<S> {
    private static final Logger jdkLog = Logger.getLogger(ServiceLoader.class.getName());
    private final Class<S> service;
    private final ClassLoader loader;
    private List<String> serviceClassNames;
    private Class<?>[] constructorParameterTypes = new Class[0];
    private Object[] constructorParameters = new Object[0];

    private ServiceLoader(Class<S> service, ClassLoader loader, List<String> servicesNames) {
        this.service = service;
        this.loader = loader;
        this.serviceClassNames = servicesNames;
    }

    public void setConstructorParameters(Class<?>[] constructorParameterTypes, Object[] constructorParameters) {
        if (constructorParameterTypes == null) {
            constructorParameterTypes = new Class[]{};
        }
        if (constructorParameters == null) {
            constructorParameters = new Object[]{};
        }
        if (constructorParameterTypes.length != constructorParameters.length) {
            throw new IllegalArgumentException("constructor types and argurments must have the same size");
        }
        this.constructorParameterTypes = constructorParameterTypes;
        this.constructorParameters = constructorParameters;
    }

    @Override
    public ServicesIterator<S> iterator() {
        return new ServicesIterator(this.loader, this.serviceClassNames.iterator(), this.constructorParameterTypes, this.constructorParameters);
    }

    public void reload() {
        ServiceLoader<S> serviceLoaderTmp = ServiceLoader.load(this.service, this.loader);
        this.serviceClassNames = serviceLoaderTmp.serviceClassNames;
    }

    public static <S> ServiceLoader<S> load(Class<S> service) {
        return ServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        ArrayList<String> serviceClassNames = new ArrayList<String>();
        try {
            Enumeration<URL> en = loader.getResources("META-INF/services/" + service.getName());
            while (en.hasMoreElements()) {
                ServiceLoader.parse(en.nextElement(), serviceClassNames);
            }
            en = loader.getResources("meta_inf/services/" + service.getName());
            while (en.hasMoreElements()) {
                ServiceLoader.parse(en.nextElement(), serviceClassNames);
            }
            return new ServiceLoader<S>(service, loader, serviceClassNames);
        }
        catch (Exception e) {
            jdkLog.log(Level.SEVERE, "Could not load services of type " + service, e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parse(URL serviceFile, List<String> serviceClassNames) {
        try {
            InputStream is = serviceFile.openStream();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String serviceClassName = null;
                while ((serviceClassName = reader.readLine()) != null) {
                    int comment = serviceClassName.indexOf(35);
                    if (comment >= 0) {
                        serviceClassName = serviceClassName.substring(0, comment);
                    }
                    if ((serviceClassName = serviceClassName.trim()).length() <= 0) continue;
                    jdkLog.log(Level.FINE, "Adding service " + serviceClassName + " from " + serviceFile);
                    serviceClassNames.add(serviceClassName);
                }
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            jdkLog.log(Level.SEVERE, "Could not parse service file " + serviceFile, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServicesIterator<S>
    implements Iterator<S> {
        private final ClassLoader loader;
        private final Iterator<String> serviceClassNames;
        private final Class<?>[] constructorParameterTypes;
        private final Object[] constructorParameters;

        private ServicesIterator(ClassLoader loader, Iterator<String> servicesNames, Class<?>[] constructorParameterTypes, Object[] constructorParameters) {
            this.loader = loader;
            this.serviceClassNames = servicesNames;
            this.constructorParameterTypes = constructorParameterTypes;
            this.constructorParameters = constructorParameters;
        }

        @Override
        public boolean hasNext() {
            return this.serviceClassNames.hasNext();
        }

        @Override
        public S next() {
            String serviceClassName = this.serviceClassNames.next();
            jdkLog.log(Level.FINE, "Loading service " + serviceClassName);
            try {
                Class<?> serviceClass = this.loader.loadClass(serviceClassName);
                return (S)serviceClass.getConstructor(this.constructorParameterTypes).newInstance(this.constructorParameters);
            }
            catch (Throwable t) {
                jdkLog.log(Level.SEVERE, "Could not load service " + serviceClassName, t);
                throw new RuntimeException(t);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

