/*
 * Decompiled with CFR 0.152.
 */
package org.granite.scan;

import java.io.IOException;
import java.io.InputStream;
import org.granite.scan.AbstractScannedItem;
import org.granite.scan.Scanner;
import org.jboss.vfs.VirtualFile;

public class VFS3FileScannedItem
extends AbstractScannedItem {
    private final VirtualFile root;
    private final VirtualFile file;
    private String relativePath = null;

    public VFS3FileScannedItem(Scanner scanner, VFS3FileScannedItem marker, VirtualFile root, VirtualFile file) {
        super(scanner, marker);
        this.root = root;
        this.file = file;
    }

    public long getSize() {
        return this.file.getSize();
    }

    public InputStream getInputStream() throws IOException {
        return this.file.openStream();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getAbsolutePath() {
        return this.file.getPathName();
    }

    public String getRelativePath() {
        if (this.relativePath == null) {
            StringBuffer sb = new StringBuffer();
            for (VirtualFile f = this.file; f != null && !this.root.equals(f); f = f.getParent()) {
                if (sb.length() > 0) {
                    sb.insert(0, '/');
                }
                sb.insert(0, f.getName());
            }
            this.relativePath = sb.toString();
        }
        return this.relativePath;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VFS3FileScannedItem)) {
            return false;
        }
        return this.file.equals(((VFS3FileScannedItem)obj).file) && this.root.equals(((VFS3FileScannedItem)obj).root);
    }

    public int hashCode() {
        return this.root.hashCode() + 31 * this.file.hashCode();
    }
}

