/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.tide.TidePersistenceManager;
import org.granite.tide.TideTransactionManager;
import org.granite.tide.data.TideTransactionPersistenceManager;
import org.granite.util.Reflections;

public abstract class AbstractTidePersistenceManager
implements TidePersistenceManager {
    private static final Logger log = Logger.getLogger(AbstractTidePersistenceManager.class);
    protected TideTransactionManager tm;

    public AbstractTidePersistenceManager(TideTransactionManager tm) {
        this.tm = tm;
        if (this.tm == null) {
            throw new RuntimeException("transaction manager is null");
        }
    }

    public Object attachEntity(Object entity, String[] propertyNames) {
        return this.attachEntity(this, entity, propertyNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object attachEntity(TidePersistenceManager pm, Object entity, String[] propertyNames) {
        Object attachedEntity = null;
        ClassGetter getter = GraniteContext.getCurrentInstance().getGraniteConfig().getClassGetter();
        try {
            Object tx = this.tm.begin(pm instanceof TideTransactionPersistenceManager ? (TideTransactionPersistenceManager)((Object)pm) : null);
            if (tx == null) {
                throw new RuntimeException("Could not initiate transaction for lazy initialization");
            }
            try {
                attachedEntity = propertyNames != null ? this.fetchEntity(entity, propertyNames) : entity;
                if (attachedEntity != null && propertyNames != null) {
                    for (int i = 0; i < propertyNames.length; ++i) {
                        Object initializedObj = attachedEntity;
                        String[] pnames = propertyNames[i].split("\\.");
                        for (int j = 0; j < pnames.length; ++j) {
                            initializedObj = Reflections.getGetterMethod(initializedObj.getClass(), pnames[j]).invoke(initializedObj, new Object[0]);
                        }
                        if (getter == null) continue;
                        getter.initialize(entity, propertyNames[i], initializedObj);
                    }
                }
                this.tm.commit(tx);
            }
            catch (Exception e) {
                String propertyName = propertyNames != null && propertyNames.length > 0 ? propertyNames[0] : "";
                log.error(e, "Error during lazy-initialization of collection: %s", propertyName);
                this.tm.rollback(tx);
            }
        }
        finally {
            this.close();
        }
        return attachedEntity;
    }

    protected abstract void close();

    public abstract Object fetchEntity(Object var1, String[] var2);
}

