/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.granite.gravity.Gravity;
import org.granite.logging.Logger;
import org.granite.tide.data.DataDispatcher;
import org.granite.tide.data.DataEnabled;
import org.granite.tide.data.DataTopicParams;
import org.granite.tide.data.DataUpdatePostprocessor;
import org.granite.tide.data.DefaultDataDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataContext {
    private static final Logger log = Logger.getLogger(DataContext.class);
    private static ThreadLocal<DataContext> dataContext = new ThreadLocal();
    private static DataContext NULL_DATA_CONTEXT = new NullDataContext();
    private DataDispatcher dataDispatcher = null;
    private DataEnabled.PublishMode publishMode = null;
    private Object[][] updates = null;
    private DataUpdatePostprocessor dataUpdatePostprocessor = null;
    private Map<Object, Object> entityExtraDataMap = new IdentityHashMap<Object, Object>();
    private final List<EntityUpdate> dataUpdates = new ArrayList<EntityUpdate>();
    private boolean published = false;

    public static void init() {
        if (dataContext.get() == null) {
            dataContext.set(NULL_DATA_CONTEXT);
        }
    }

    public static void init(String topic, Class<? extends DataTopicParams> dataTopicParamsClass, DataEnabled.PublishMode publishMode) {
        DataContext dc = new DataContext(null, topic, dataTopicParamsClass, publishMode);
        dataContext.set(dc);
    }

    public static void init(Gravity gravity, String topic, Class<? extends DataTopicParams> dataTopicParamsClass, DataEnabled.PublishMode publishMode) {
        DataContext dc = new DataContext(gravity, topic, dataTopicParamsClass, publishMode);
        dataContext.set(dc);
    }

    public static void init(DataDispatcher dataDispatcher, DataEnabled.PublishMode publishMode) {
        DataContext dc = new DataContext(dataDispatcher, publishMode);
        dataContext.set(dc);
    }

    private DataContext(Gravity gravity, String topic, Class<? extends DataTopicParams> dataTopicParamsClass, DataEnabled.PublishMode publishMode) {
        log.debug("Init Gravity data context for topic %s and mode %s", new Object[]{topic, publishMode});
        this.dataDispatcher = new DefaultDataDispatcher(gravity, topic, dataTopicParamsClass);
        this.publishMode = publishMode;
    }

    private DataContext(DataDispatcher dataDispatcher, DataEnabled.PublishMode publishMode) {
        log.debug("Init data context with custom dispatcher %s and mode %s", new Object[]{dataDispatcher, publishMode});
        this.dataDispatcher = dataDispatcher;
        this.publishMode = publishMode;
    }

    public static DataContext get() {
        return dataContext.get();
    }

    public static void remove() {
        log.debug("Remove data context", new Object[0]);
        dataContext.remove();
    }

    public static boolean isNull() {
        return dataContext.get() == NULL_DATA_CONTEXT;
    }

    public List<EntityUpdate> getDataUpdates() {
        return this.dataUpdates;
    }

    public Object[][] getUpdates() {
        if (this.updates != null) {
            return this.updates;
        }
        if (this.dataUpdates == null || this.dataUpdates.isEmpty()) {
            return null;
        }
        List<EntityUpdate> processedDataUpdates = this.dataUpdates;
        if (this.dataUpdatePostprocessor != null) {
            processedDataUpdates = this.dataUpdatePostprocessor.process(this.dataUpdates);
        }
        Collections.sort(processedDataUpdates);
        this.updates = new Object[processedDataUpdates.size()][];
        int i = 0;
        for (EntityUpdate u : processedDataUpdates) {
            this.updates[i++] = u.toArray();
        }
        return this.updates;
    }

    public void setDataUpdatePostprocessor(DataUpdatePostprocessor dataUpdatePostprocessor) {
        this.dataUpdatePostprocessor = dataUpdatePostprocessor;
    }

    public static void addUpdate(EntityUpdateType type, Object entity) {
        DataContext.addUpdate(type, entity, 0);
    }

    public static void addUpdate(EntityUpdateType type, Object entity, int priority) {
        DataContext dc = DataContext.get();
        if (dc != null && dc.dataDispatcher != null) {
            for (EntityUpdate update : dc.dataUpdates) {
                if (!update.type.equals((Object)type) || !update.entity.equals(entity)) continue;
                if (update.priority < priority) {
                    update.priority = priority;
                }
                return;
            }
            dc.dataUpdates.add(new EntityUpdate(type, entity, priority));
            dc.updates = null;
        }
    }

    public static void addEntityExtraData(Object entity, Object extraData) {
        DataContext dc = DataContext.get();
        if (dc != null && dc.entityExtraDataMap != null) {
            dc.entityExtraDataMap.put(entity, extraData);
        }
    }

    public static Object getEntityExtraData(Object entity) {
        DataContext dc = DataContext.get();
        return dc != null && dc.entityExtraDataMap != null ? dc.entityExtraDataMap.get(entity) : null;
    }

    public static void observe() {
        DataContext dc = DataContext.get();
        if (dc != null && dc.dataDispatcher != null) {
            log.debug("Observe data updates", new Object[0]);
            dc.dataDispatcher.observe();
        }
    }

    public static void publish() {
        DataContext.publish(DataEnabled.PublishMode.MANUAL);
    }

    public static void publish(DataEnabled.PublishMode publishMode) {
        DataContext dc = DataContext.get();
        if (!(dc == null || dc.dataDispatcher == null || dc.dataUpdates.isEmpty() || dc.published || publishMode != DataEnabled.PublishMode.MANUAL && !dc.publishMode.equals((Object)publishMode))) {
            log.debug("Publish %s data updates with mode %s", new Object[]{dc.dataUpdates.size(), dc.publishMode});
            dc.dataDispatcher.publish(dc.getUpdates());
            dc.published = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullDataContext
    extends DataContext {
        public NullDataContext() {
            super(null, null);
        }

        @Override
        public List<EntityUpdate> getDataUpdates() {
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntityUpdate
    implements Comparable<EntityUpdate> {
        public EntityUpdateType type;
        public Object entity;
        public int priority = 0;

        public EntityUpdate(EntityUpdateType type, Object entity, int priority) {
            this.type = type;
            this.entity = entity;
            this.priority = priority;
        }

        @Override
        public int compareTo(EntityUpdate u) {
            if (this.type.ordinal() != u.type.ordinal()) {
                return this.type.ordinal() - u.type.ordinal();
            }
            if (!this.entity.equals(u.entity)) {
                return this.entity.hashCode() - u.entity.hashCode();
            }
            return this.priority - u.priority;
        }

        public Object[] toArray() {
            return new Object[]{this.type.name(), this.entity};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntityUpdateType {
        PERSIST,
        UPDATE,
        REMOVE;

    }
}

