/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.ejb;

import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.naming.InitialContext;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.granite.tide.data.DataContext;
import org.granite.tide.data.DataEnabled;
import org.granite.tide.data.JMSDataDispatcher;
import org.granite.tide.data.TideDataPublishingSynchronization;

@Interceptor
public class TideDataPublishingInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object processPublishData(InvocationContext invocationContext) throws Exception {
        if (invocationContext.getMethod() == null) {
            return invocationContext.proceed();
        }
        DataEnabled dataEnabled = invocationContext.getTarget().getClass().getAnnotation(DataEnabled.class);
        if (dataEnabled == null || !dataEnabled.useInterceptor()) {
            return invocationContext.proceed();
        }
        boolean shouldRemoveContextAtEnd = DataContext.get() == null;
        boolean shouldInitContext = shouldRemoveContextAtEnd || DataContext.isNull();
        boolean onCommit = false;
        if (shouldInitContext) {
            DataContext.init(new JMSDataDispatcher(dataEnabled.topic(), onCommit, dataEnabled.params()), dataEnabled.publish());
        }
        DataContext.observe();
        try {
            if (dataEnabled.publish().equals((Object)DataEnabled.PublishMode.ON_COMMIT)) {
                InitialContext ctx = new InitialContext();
                TransactionSynchronizationRegistry tsr = (TransactionSynchronizationRegistry)ctx.lookup("java:comp/TransactionSynchronizationRegistry");
                tsr.registerInterposedSynchronization((Synchronization)new TideDataPublishingSynchronization(shouldRemoveContextAtEnd));
                onCommit = true;
            }
            Object ret = invocationContext.proceed();
            DataContext.publish(DataEnabled.PublishMode.ON_SUCCESS);
            Object object = ret;
            return object;
        }
        finally {
            if (shouldRemoveContextAtEnd && !onCommit) {
                DataContext.remove();
            }
        }
    }
}

