/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator;

import java.io.IOException;
import org.granite.generator.Configuration;
import org.granite.generator.Input;
import org.granite.generator.Listener;
import org.granite.generator.Output;
import org.granite.generator.exception.GenerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transformer<I extends Input<?>, O extends Output<?>, C extends Configuration> {
    private C config = null;
    private Listener listener = null;

    public Transformer() {
    }

    public Transformer(Configuration config, Listener listener) {
        this.setConfig(config);
        this.listener = listener;
    }

    public C getConfig() {
        return this.config;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    protected abstract boolean accept(Input<?> var1);

    protected abstract O[] getOutputs(I var1) throws IOException, GenerationException;

    public Output<?>[] generate(Input<?> input) throws IOException, GenerationException {
        Output[] outputs;
        for (Output output : outputs = this.getOutputs(input)) {
            if (output.isOutdated()) {
                this.listener.generating(input, output);
                this.generate(input, output);
                continue;
            }
            this.listener.skipping(input, output);
        }
        return outputs;
    }

    protected abstract void generate(I var1, O var2) throws IOException, GenerationException;

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return this.getClass().getName();
    }
}

