/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.granite.generator.Generator;
import org.granite.generator.Output;
import org.granite.generator.TemplateUri;
import org.granite.generator.Transformer;
import org.granite.generator.ant.AntListener;
import org.granite.generator.as3.As3TypeFactory;
import org.granite.generator.as3.DefaultAs3TypeFactory;
import org.granite.generator.as3.DefaultEntityFactory;
import org.granite.generator.as3.DefaultRemoteDestinationFactory;
import org.granite.generator.as3.EntityFactory;
import org.granite.generator.as3.JavaAs3GroovyConfiguration;
import org.granite.generator.as3.JavaAs3GroovyTransformer;
import org.granite.generator.as3.JavaAs3Input;
import org.granite.generator.as3.PackageTranslator;
import org.granite.generator.as3.RemoteDestinationFactory;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.gsp.GroovyTemplateFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntJavaAs3Task
extends Task
implements JavaAs3GroovyConfiguration {
    private String outputdir = ".";
    private String baseoutputdir = null;
    private String uid = "uid";
    private String entitytemplate = null;
    private String entitybasetemplate = null;
    private String beantemplate = null;
    private String beanbasetemplate = null;
    private String interfacetemplate = null;
    private String enumtemplate = null;
    private String remotetemplate = null;
    private String remotebasetemplate = null;
    private boolean tide = false;
    private String as3typefactory = null;
    private String entityfactory = null;
    private String remotedestinationfactory = null;
    private String transformer = null;
    private boolean externalizelong = false;
    private boolean externalizebiginteger = false;
    private boolean externalizebigdecimal = false;
    private Path classpath = null;
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private List<PackageTranslator> translators = new ArrayList<PackageTranslator>();
    private File outputDirFile = null;
    private File baseOutputDirFile = null;
    private As3TypeFactory as3TypeFactoryImpl = null;
    private Transformer<?, ?, ?> transformerImpl = null;
    private EntityFactory entityFactoryImpl = null;
    private RemoteDestinationFactory remoteDestinationFactoryImpl = null;
    private GroovyTemplateFactory groovyTemplateFactory = null;
    private TemplateUri[] entityTemplateUris = null;
    private TemplateUri[] interfaceTemplateUris = null;
    private TemplateUri[] beanTemplateUris = null;
    private TemplateUri[] enumTemplateUris = null;
    private TemplateUri[] remoteTemplateUris = null;
    private Map<Class<?>, File> filesetClasses = null;

    public void setOutputdir(String outputdir) {
        this.outputdir = outputdir;
    }

    public void setBaseoutputdir(String baseoutputdir) {
        this.baseoutputdir = baseoutputdir;
    }

    public void setAs3typefactory(String as3typefactory) {
        this.as3typefactory = as3typefactory;
    }

    public void setEntityfactory(String entityfactory) {
        this.entityfactory = entityfactory;
    }

    public void setRemotedestinationfactory(String remotedestinationfactory) {
        this.remotedestinationfactory = remotedestinationfactory;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setEntitytemplate(String entitytemplate) {
        this.entitytemplate = entitytemplate;
    }

    public void setEntitybasetemplate(String entitybasetemplate) {
        this.entitybasetemplate = entitybasetemplate;
    }

    public void setBeantemplate(String beantemplate) {
        this.beantemplate = beantemplate;
    }

    public void setBeanbasetemplate(String beanbasetemplate) {
        this.beanbasetemplate = beanbasetemplate;
    }

    public void setInterfacetemplate(String interfacetemplate) {
        this.interfacetemplate = interfacetemplate;
    }

    public void setEnumtemplate(String enumtemplate) {
        this.enumtemplate = enumtemplate;
    }

    public void setRemotetemplate(String remotetemplate) {
        this.remotetemplate = remotetemplate;
    }

    public void setRemotebasetemplate(String remotebasetemplate) {
        this.remotebasetemplate = remotebasetemplate;
    }

    public void setTide(boolean tide) {
        this.tide = tide;
    }

    public void setExternalizelong(boolean externalizelong) {
        this.externalizelong = externalizelong;
    }

    public void setExternalizebiginteger(boolean externalizebiginteger) {
        this.externalizebiginteger = externalizebiginteger;
    }

    public void setExternalizebigdecimal(boolean externalizebigdecimal) {
        this.externalizebigdecimal = externalizebigdecimal;
    }

    public void setTransformer(String transformer) {
        this.transformer = transformer;
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void addTranslator(PackageTranslator translator) {
        this.translators.add(translator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.log("Using output dir: " + this.outputdir, 2);
        this.log("Using classpath: " + this.classpath, 2);
        AntClassLoader loader = new AntClassLoader(AntJavaAs3Task.class.getClassLoader(), this.getProject(), this.classpath, true);
        try {
            loader.setThreadContextLoader();
            this.log("Loading all Java classes referenced by inner fileset(s) {", 2);
            this.filesetClasses = new HashMap();
            for (FileSet fileSet : this.fileSets) {
                String[] names;
                DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                scanner.setCaseSensitive(true);
                scanner.scan();
                StringBuilder sb = new StringBuilder("    ");
                for (String name : names = scanner.getIncludedFiles()) {
                    if (name.endsWith(".class")) {
                        this.log(name, 3);
                        try {
                            File jFile = new File(scanner.getBasedir(), name);
                            if (!jFile.exists()) {
                                throw new FileNotFoundException(jFile.toString());
                            }
                            String jClassName = name.substring(0, name.length() - 6).replace(File.separatorChar, '.');
                            Class jClass = loader.loadClass(jClassName);
                            if (jClass.isMemberClass() && !jClass.isEnum()) continue;
                            sb.setLength(4);
                            sb.append(jClass.toString());
                            this.log(sb.toString(), 2);
                            this.filesetClasses.put(jClass, jFile);
                            continue;
                        }
                        catch (Exception e) {
                            this.log(AntJavaAs3Task.getStackTrace(e));
                            throw new BuildException("Could not load Java class file: " + name, (Throwable)e);
                        }
                    }
                    this.log("Skipping non class file: " + name, 1);
                }
            }
            this.log("}", 2);
            this.log("Setting up the generator...", 2);
            if (this.as3typefactory == null) {
                this.as3TypeFactoryImpl = new DefaultAs3TypeFactory();
                this.as3TypeFactoryImpl.configure(this.externalizelong, this.externalizebiginteger, this.externalizebigdecimal);
            } else {
                this.log("Instantiating custom As3TypeFactory class: " + this.as3typefactory, 2);
                this.as3TypeFactoryImpl = (As3TypeFactory)this.newInstance((ClassLoader)loader, this.as3typefactory);
            }
            if (this.entityfactory == null) {
                this.entityFactoryImpl = new DefaultEntityFactory();
            } else {
                this.log("Instantiating custom EntityFactory class: " + this.entityfactory, 2);
                this.entityFactoryImpl = (EntityFactory)this.newInstance((ClassLoader)loader, this.entityfactory);
            }
            if (this.remotedestinationfactory == null) {
                this.remoteDestinationFactoryImpl = new DefaultRemoteDestinationFactory();
            } else {
                this.log("Instantiating custom RemoteDestinationFactory class: " + this.remotedestinationfactory, 2);
                this.remoteDestinationFactoryImpl = (RemoteDestinationFactory)this.newInstance((ClassLoader)loader, this.remotedestinationfactory);
            }
            AntListener listener = new AntListener(this);
            if (this.transformer == null) {
                this.transformerImpl = new JavaAs3GroovyTransformer();
            } else {
                this.log("Instantiating custom Transformer class: " + this.transformer, 2);
                this.transformerImpl = (Transformer)this.newInstance((ClassLoader)loader, this.transformer);
            }
            this.transformerImpl.setListener(listener);
            String baseTemplateUri = null;
            String templateUri = "class:org/granite/generator/template/enum.gsp";
            if (this.enumtemplate != null) {
                this.log("Using custom enum template: " + this.enumtemplate, 2);
                templateUri = this.enumtemplate;
            }
            this.enumTemplateUris = this.createTemplateUris(baseTemplateUri, templateUri);
            templateUri = "class:org/granite/generator/template/interface.gsp";
            if (this.interfacetemplate != null) {
                this.log("Using custom interface template: " + this.interfacetemplate, 2);
                templateUri = this.interfacetemplate;
            }
            this.interfaceTemplateUris = this.createTemplateUris(baseTemplateUri, templateUri);
            baseTemplateUri = "class:org/granite/generator/template/entityBase.gsp";
            templateUri = "class:org/granite/generator/template/entity.gsp";
            if (this.entitytemplate != null) {
                this.log("Using custom entity template: " + this.entitytemplate, 2);
                templateUri = this.entitytemplate;
            }
            if (this.entitybasetemplate != null) {
                this.log("Using custom entity base template: " + this.entitybasetemplate, 2);
                baseTemplateUri = this.entitybasetemplate;
            } else if (this.tide) {
                this.log("Using tide entity base template.", 2);
                baseTemplateUri = "class:org/granite/generator/template/tideEntityBase.gsp";
            }
            this.entityTemplateUris = this.createTemplateUris(baseTemplateUri, templateUri);
            baseTemplateUri = "class:org/granite/generator/template/beanBase.gsp";
            templateUri = "class:org/granite/generator/template/bean.gsp";
            if (this.beantemplate != null) {
                this.log("Using custom bean template: " + this.beantemplate, 2);
                templateUri = this.beantemplate;
            }
            if (this.beanbasetemplate != null) {
                this.log("Using custom bean base template: " + this.beanbasetemplate, 2);
                baseTemplateUri = this.beanbasetemplate;
            } else if (this.tide) {
                this.log("Using tide bean base template.", 2);
                baseTemplateUri = "class:org/granite/generator/template/tideBeanBase.gsp";
            }
            this.beanTemplateUris = this.createTemplateUris(baseTemplateUri, templateUri);
            baseTemplateUri = "class:org/granite/generator/template/remoteBase.gsp";
            templateUri = "class:org/granite/generator/template/remote.gsp";
            if (this.remotetemplate != null) {
                this.log("Using custom remote template: " + this.remotetemplate, 2);
                templateUri = this.remotetemplate;
            }
            if (this.remotebasetemplate != null) {
                this.log("Using custom remote base template: " + this.remotebasetemplate, 2);
                baseTemplateUri = this.remotebasetemplate;
            } else if (this.tide) {
                this.log("Using tide remote destination base template.", 2);
                baseTemplateUri = "class:org/granite/generator/template/tideRemoteBase.gsp";
            }
            this.remoteTemplateUris = this.createTemplateUris(baseTemplateUri, templateUri);
            Generator generator = new Generator(this);
            generator.add(this.transformerImpl);
            this.log("Calling the generator for each Java class {", 2);
            int count = 0;
            for (Map.Entry<Class<?>, File> classFile : this.filesetClasses.entrySet()) {
                if (classFile.getKey().isAnonymousClass()) continue;
                try {
                    JavaAs3Input input = new JavaAs3Input(classFile.getKey(), classFile.getValue());
                    for (Output<?> output : generator.generate(input)) {
                        if (!output.isOutdated()) continue;
                        ++count;
                    }
                }
                catch (Exception e) {
                    this.log(AntJavaAs3Task.getStackTrace(e));
                    throw new BuildException("Could not generate AS3 beans for: " + classFile.getKey(), (Throwable)e);
                }
            }
            this.log("}", 2);
            this.log("Files affected: " + count + (count == 0 ? " (nothing to do)." : "."));
        }
        finally {
            loader.resetThreadContextLoader();
        }
    }

    @Override
    public As3TypeFactory getAs3TypeFactory() {
        return this.as3TypeFactoryImpl;
    }

    @Override
    public EntityFactory getEntityFactory() {
        return this.entityFactoryImpl;
    }

    @Override
    public RemoteDestinationFactory getRemoteDestinationFactory() {
        return this.remoteDestinationFactoryImpl;
    }

    @Override
    public File getBaseOutputDir(JavaAs3Input input) {
        if (this.baseOutputDirFile == null) {
            this.baseOutputDirFile = new File(this.baseoutputdir != null ? this.baseoutputdir : this.outputdir);
        }
        return this.baseOutputDirFile;
    }

    @Override
    public File getOutputDir(JavaAs3Input input) {
        if (this.outputDirFile == null) {
            this.outputDirFile = new File(this.outputdir);
        }
        return this.outputDirFile;
    }

    @Override
    public TemplateUri[] getTemplateUris(JavaType.Kind kind, Class<?> clazz) {
        switch (kind) {
            case ENTITY: {
                return this.entityTemplateUris;
            }
            case INTERFACE: {
                return this.interfaceTemplateUris;
            }
            case ENUM: {
                return this.enumTemplateUris;
            }
            case BEAN: {
                return this.beanTemplateUris;
            }
            case REMOTE_DESTINATION: {
                return this.remoteTemplateUris;
            }
        }
        throw new IllegalArgumentException("Unknown template kind: " + (Object)((Object)kind) + " / " + clazz);
    }

    @Override
    public List<PackageTranslator> getTranslators() {
        return this.translators;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public boolean isGenerated(Class<?> clazz) {
        return this.filesetClasses.containsKey(clazz);
    }

    @Override
    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public GroovyTemplateFactory getGroovyTemplateFactory() {
        if (this.groovyTemplateFactory == null) {
            this.groovyTemplateFactory = new GroovyTemplateFactory();
        }
        return this.groovyTemplateFactory;
    }

    private <T> T newInstance(ClassLoader loader, String className) {
        try {
            return (T)loader.loadClass(className).newInstance();
        }
        catch (Exception e) {
            this.log(AntJavaAs3Task.getStackTrace(e));
            throw new BuildException("Could not instantiate custom class: " + className, (Throwable)e);
        }
    }

    private static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private TemplateUri[] createTemplateUris(String baseUri, String uri) {
        TemplateUri[] templateUris = new TemplateUri[baseUri == null ? 1 : 2];
        int i = 0;
        if (baseUri != null) {
            templateUris[i++] = new TemplateUri(baseUri, true);
        }
        templateUris[i] = new TemplateUri(uri, false);
        return templateUris;
    }
}

