/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.granite.generator.Output;
import org.granite.generator.Template;
import org.granite.generator.as3.As3Type;
import org.granite.generator.as3.reflect.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAs3Output
implements Output<As3Type> {
    private final JavaType javaType;
    private final As3Type targetType;
    private final Template template;
    private final File dir;
    private final File file;
    private final boolean outdated;
    private final String message;

    public JavaAs3Output(JavaType javaType, Template template, File dir, File file, boolean outdated, String message) {
        this.javaType = javaType;
        this.targetType = javaType.getAs3Type();
        this.template = template;
        this.dir = dir;
        this.file = file;
        this.outdated = outdated;
        this.message = message;
    }

    public JavaType getJavaType() {
        return this.javaType;
    }

    @Override
    public As3Type getTargetType() {
        return this.targetType;
    }

    @Override
    public String getDescription() {
        return this.file.toString();
    }

    public Template getTemplate() {
        return this.template;
    }

    public File getDir() {
        return this.dir;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isOutdated() {
        return this.outdated;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public OutputStream openStream() throws IOException {
        File parent = this.file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        return new BufferedOutputStream(new FileOutputStream(this.file));
    }

    public PrintWriter openWriter() throws IOException {
        File parent = this.file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        return new PrintWriter(new BufferedWriter(new FileWriter(this.file)));
    }
}

