/*
 * Decompiled with CFR 0.152.
 */
package org.granite.generator.as3.reflect;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.generator.as3.reflect.JavaAbstractType;
import org.granite.generator.as3.reflect.JavaImport;
import org.granite.generator.as3.reflect.JavaInterface;
import org.granite.generator.as3.reflect.JavaMethod;
import org.granite.generator.as3.reflect.JavaMethodProperty;
import org.granite.generator.as3.reflect.JavaType;
import org.granite.generator.as3.reflect.JavaTypeFactory;
import org.granite.messaging.service.annotations.IgnoredMethod;
import org.granite.messaging.service.annotations.RemoteDestination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaRemoteDestination
extends JavaAbstractType {
    protected final Set<JavaImport> imports = new HashSet<JavaImport>();
    protected final JavaType superclass;
    protected final List<JavaMethod> methods;
    protected final Map<String, JavaMethodProperty> properties;
    protected final String destinationName;
    protected final String channelId;

    public JavaRemoteDestination(JavaTypeFactory provider, Class<?> type, URL url) {
        super(provider, type, url);
        RemoteDestination rd;
        this.superclass = provider.getJavaTypeSuperclass(type);
        this.methods = Collections.unmodifiableList(this.initMethods());
        this.properties = Collections.unmodifiableMap(this.initProperties());
        if (this.superclass != null) {
            this.addToImports(provider.getJavaImport(this.superclass.getType()));
        }
        if ((rd = type.getAnnotation(RemoteDestination.class)) != null) {
            this.destinationName = rd.id();
            this.channelId = rd.channel();
        } else {
            this.destinationName = null;
            this.channelId = null;
        }
    }

    public Set<JavaImport> getImports() {
        return this.imports;
    }

    protected void addToImports(JavaImport javaImport) {
        if (javaImport != null) {
            this.imports.add(javaImport);
        }
    }

    public boolean hasSuperclass() {
        return this.superclass != null;
    }

    public JavaType getSuperclass() {
        return this.superclass;
    }

    public Collection<JavaMethod> getMethods() {
        return this.methods;
    }

    public Collection<JavaMethodProperty> getProperties() {
        return this.properties.values();
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.type.isAnnotationPresent(annotation);
    }

    protected List<JavaMethod> initMethods() {
        ArrayList<JavaMethod> methodMap = new ArrayList<JavaMethod>();
        Method[] methods = null;
        methods = this.type.isInterface() ? this.type.getMethods() : this.type.getDeclaredMethods();
        for (Method method : methods) {
            if (!this.shouldGenerateMethod(method)) continue;
            for (Class<?> clazz : method.getParameterTypes()) {
                if (clazz.isMemberClass() && !clazz.isEnum()) {
                    throw new UnsupportedOperationException("Inner classes are not supported (except enums): " + clazz);
                }
                this.addToImports(this.provider.getJavaImport(clazz));
            }
            methodMap.add(new JavaMethod(method, JavaMethod.MethodType.OTHER, this.provider));
        }
        return methodMap;
    }

    protected boolean shouldGenerateMethod(Method method) {
        return Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && !method.isAnnotationPresent(IgnoredMethod.class);
    }

    protected Map<String, JavaMethodProperty> initProperties() {
        LinkedHashMap<String, JavaMethodProperty> propertyMap = new LinkedHashMap<String, JavaMethodProperty>();
        Method[] methods = null;
        methods = this.type.isInterface() ? this.type.getMethods() : this.type.getDeclaredMethods();
        ArrayList<Object[]> tmp = new ArrayList<Object[]>();
        for (Method method : methods) {
            if (!this.shouldGenerateProperty(method)) continue;
            for (Class<?> clazz : method.getParameterTypes()) {
                this.addToImports(this.provider.getJavaImport(clazz));
            }
            this.addToImports(this.provider.getJavaImport(method.getReturnType()));
            String propertyName = Introspector.decapitalize(method.getName().startsWith("is") ? method.getName().substring(2) : method.getName().substring(3));
            Object[] property = null;
            for (Object[] mp : tmp) {
                if (!mp[0].equals(propertyName)) continue;
                property = mp;
                break;
            }
            if (property == null) {
                property = new Object[]{propertyName, null, null};
                tmp.add(property);
            }
            if (method.getName().startsWith("set")) {
                property[2] = method;
                continue;
            }
            property[1] = method;
        }
        for (Object[] property : tmp) {
            JavaMethod readMethod = property[1] != null ? new JavaMethod((Method)property[1], JavaMethod.MethodType.GETTER) : null;
            JavaMethod writeMethod = property[2] != null ? new JavaMethod((Method)property[2], JavaMethod.MethodType.SETTER) : null;
            propertyMap.put((String)property[0], new JavaMethodProperty(this.provider, (String)property[0], readMethod, writeMethod));
        }
        return propertyMap;
    }

    protected boolean shouldGenerateProperty(Method method) {
        return false;
    }

    public JavaInterface convertToJavaInterface() {
        return new JavaInterface(this.getProvider(), this.getType(), this.getUrl());
    }
}

