/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.context.GraniteContext;
import org.granite.gravity.AbstractGravityServlet;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityManager;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.util.ContentType;
import org.granite.util.UUIDUtil;

public class GravityServletUtil {
    public static final String CONNECT_MESSAGE_KEY = AbstractGravityServlet.class.getName() + ".CONNECT_MESSAGE";

    public static void init(ServletConfig config) throws ServletException {
        GravityManager.start(config);
    }

    public static void setConnectMessage(HttpServletRequest request, Message connect) {
        if (!(connect instanceof CommandMessage) && ((CommandMessage)connect).getOperation() != 20) {
            throw new IllegalArgumentException("Not a connect message: " + connect);
        }
        request.setAttribute(CONNECT_MESSAGE_KEY, (Object)connect);
    }

    public static CommandMessage getConnectMessage(HttpServletRequest request) {
        return (CommandMessage)request.getAttribute(CONNECT_MESSAGE_KEY);
    }

    public static void removeConnectMessage(HttpServletRequest request) {
        request.removeAttribute(CONNECT_MESSAGE_KEY);
    }

    public static long getLongPollingTimeout(ServletContext context) {
        return GravityManager.getGravity(context).getGravityConfig().getLongPollingTimeoutMillis();
    }

    public static Gravity initializeRequest(ServletConfig config, Gravity gravity, HttpServletRequest request, HttpServletResponse response) {
        HttpGraniteContext.createThreadIntance(gravity.getGraniteConfig(), gravity.getServicesConfig(), config.getServletContext(), request, response);
        return gravity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message[] deserialize(Gravity gravity, HttpServletRequest request) throws ClassNotFoundException, IOException {
        ServletInputStream is = request.getInputStream();
        try {
            Message[] messageArray = GravityServletUtil.deserialize(gravity, request, (InputStream)is);
            return messageArray;
        }
        finally {
            is.close();
        }
    }

    public static Message[] deserialize(Gravity gravity, HttpServletRequest request, InputStream is) throws ClassNotFoundException, IOException {
        ObjectInput amf3Deserializer = gravity.getGraniteConfig().newAMF3Deserializer(is);
        Object[] objects = (Object[])amf3Deserializer.readObject();
        Message[] messages = new Message[objects.length];
        System.arraycopy(objects, 0, messages, 0, objects.length);
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Gravity gravity, HttpServletResponse response, Message[] messages) throws IOException {
        OutputStream os = null;
        try {
            String dsId = null;
            for (Message message : messages) {
                if (!"nil".equals(message.getHeader("DSId"))) continue;
                if (dsId == null) {
                    dsId = UUIDUtil.randomUUID();
                }
                message.getHeaders().put("DSId", dsId);
            }
            response.setStatus(200);
            response.setContentType(ContentType.AMF.mimeType());
            response.setDateHeader("Expire", 0L);
            response.setHeader("Cache-Control", "no-store");
            os = response.getOutputStream();
            ObjectOutput amf3Serializer = gravity.getGraniteConfig().newAMF3Serializer(os);
            amf3Serializer.writeObject(messages);
            os.flush();
            response.flushBuffer();
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    public static void cleanupRequest(HttpServletRequest request) {
        GraniteContext.release();
    }
}

