/*
 * Decompiled with CFR 0.152.
 */
package org.granite.logging;

import org.granite.logging.Logger;
import org.granite.logging.LoggingFormatter;
import org.slf4j.LoggerFactory;

public class Slf4jLogger
extends Logger {
    public Slf4jLogger(String name, LoggingFormatter formatter) {
        super(LoggerFactory.getLogger((String)name), formatter);
    }

    protected org.slf4j.Logger getLoggerImpl() {
        return (org.slf4j.Logger)super.getLoggerImpl();
    }

    @Override
    public void info(String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.getLoggerImpl().info(this.getFormatter().format(message, args));
        }
    }

    @Override
    public void info(Throwable t, String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.getLoggerImpl().info(this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public void trace(String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.getLoggerImpl().trace(this.getFormatter().format(message, args));
        }
    }

    @Override
    public void trace(Throwable t, String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.getLoggerImpl().trace(this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.getLoggerImpl().warn(this.getFormatter().format(message, args));
        }
    }

    @Override
    public void warn(Throwable t, String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.getLoggerImpl().warn(this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.getLoggerImpl().debug(this.getFormatter().format(message, args));
        }
    }

    @Override
    public void debug(Throwable t, String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.getLoggerImpl().debug(this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.getLoggerImpl().error(this.getFormatter().format(message, args));
        }
    }

    @Override
    public void error(Throwable t, String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.getLoggerImpl().error(this.getFormatter().format(message, args), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLoggerImpl().isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getLoggerImpl().isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.getLoggerImpl().isErrorEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLoggerImpl().isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLoggerImpl().isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.getLoggerImpl().isWarnEnabled();
    }
}

