/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.BooleanCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;

public class BooleanCodecImpl
extends AbstractStandardCodec<Boolean>
implements BooleanCodec {
    @Override
    public int getObjectType() {
        return 57;
    }

    @Override
    public Class<?> getObjectClass() {
        return Boolean.class;
    }

    @Override
    public int getPrimitiveType() {
        return 56;
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Boolean.TYPE;
    }

    @Override
    public void encode(OutputContext ctx, Boolean v) throws IOException {
        if (v.booleanValue()) {
            ctx.getOutputStream().write(185);
        } else {
            ctx.getOutputStream().write(57);
        }
    }

    @Override
    public Boolean decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 57) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        return (parameterizedJmfType & 0x80) != 0;
    }

    @Override
    public void encodePrimitive(OutputContext ctx, boolean v) throws IOException {
        if (v) {
            ctx.getOutputStream().write(184);
        } else {
            ctx.getOutputStream().write(56);
        }
    }

    @Override
    public boolean decodePrimitive(InputContext ctx) throws IOException {
        int parameterizedJmfType = ctx.safeRead();
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 56) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        return (parameterizedJmfType & 0x80) != 0;
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 56: {
                ctx.indentPrintLn("boolean: " + ((parameterizedJmfType & 0x80) != 0));
                break;
            }
            case 57: {
                ctx.indentPrintLn(Boolean.class.getName() + ": " + ((parameterizedJmfType & 0x80) != 0));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }
}

