/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.granite.util.TypeUtil;

public class MapUtil {
    public static Type[] getComponentTypes(Type mapType) {
        Type[] argTypes;
        Class<?> mapClass = TypeUtil.classOfType(mapType);
        if (!Map.class.isAssignableFrom(mapClass)) {
            return null;
        }
        Type[] componentTypes = new Type[]{WildcardType.class, WildcardType.class};
        if (mapType instanceof ParameterizedType && (argTypes = ((ParameterizedType)mapType).getActualTypeArguments()) != null) {
            if (argTypes.length > 0) {
                componentTypes[0] = argTypes[0];
            }
            if (argTypes.length > 1) {
                componentTypes[1] = argTypes[1];
            }
        }
        return componentTypes;
    }

    public static Map<Object, Object> newMap(Class<?> targetClass, int length) throws InstantiationException, IllegalAccessException {
        if (targetClass.isInterface()) {
            if (SortedMap.class.isAssignableFrom(targetClass)) {
                return new TreeMap<Object, Object>();
            }
            if (targetClass.isAssignableFrom(HashMap.class)) {
                return new HashMap<Object, Object>(length);
            }
            throw new IllegalArgumentException("Unsupported collection interface: " + targetClass);
        }
        return (Map)targetClass.newInstance();
    }
}

