/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.granite.config.GraniteConfig;
import org.granite.config.ServletGraniteConfig;
import org.granite.config.ShutdownListener;
import org.granite.config.flex.ServletServicesConfig;
import org.granite.jmx.GraniteMBeanInitializer;
import org.granite.logging.Logger;
import org.granite.messaging.DefaultAliasRegistry;
import org.granite.messaging.jmf.DefaultCodecRegistry;
import org.granite.messaging.jmf.DefaultSharedContext;
import org.granite.messaging.jmf.SharedContext;
import org.granite.messaging.jmf.codec.ExtendedObjectCodec;
import org.granite.messaging.jmf.codec.ExtendedObjectCodecService;
import org.granite.messaging.reflect.Reflection;
import org.granite.scan.ServiceLoader;
import org.granite.util.JMFAMFUtil;
import org.granite.util.ServletParams;

public class GraniteConfigListener
implements ServletContextListener,
HttpSessionListener {
    private static final String GRANITE_CONFIG_SHUTDOWN_KEY = GraniteConfig.class.getName() + "_SHUTDOWN";
    public static final String GRANITE_CONFIG_ATTRIBUTE = "org.granite.config.serverFilter";
    public static final String GRANITE_CONFIG_PROVIDER_ATTRIBUTE = "org.granite.config.configProvider";
    public static final String GRANITE_MBEANS_ATTRIBUTE = "registerGraniteMBeans";
    public static final String GRANITE_SESSION_TRACKING = "org.granite.config.sessionTracking";
    public static final String GRANITE_SESSION_MAP = "org.granite.config.sessionMap";
    public static final String JMF_INITIALIZATION = "jmf-initialization";
    public static final String SHARED_CONTEXT_KEY = SharedContext.class.getName();
    public static final String DUMP_SHARED_CONTEXT_KEY = SharedContext.class.getName() + ":DUMP";
    private static final Logger log = Logger.getLogger(GraniteConfigListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        try {
            String jmfInitialization;
            log.info("Initializing GraniteDS...", new Object[0]);
            ServiceConfigurator serviceConfigurator = (ServiceConfigurator)context.getAttribute(GRANITE_CONFIG_ATTRIBUTE);
            if (serviceConfigurator != null) {
                serviceConfigurator.initialize(context);
            }
            GraniteConfig gConfig = ServletGraniteConfig.loadConfig(context);
            ServletServicesConfig.loadConfig(context);
            if (serviceConfigurator != null) {
                serviceConfigurator.configureServices(context);
            }
            if ("true".equals(context.getInitParameter(GRANITE_SESSION_TRACKING))) {
                ConcurrentHashMap sessionMap = new ConcurrentHashMap(200);
                context.setAttribute(GRANITE_SESSION_MAP, sessionMap);
            }
            if (gConfig.isRegisterMBeans()) {
                GraniteMBeanInitializer.registerMBeans(context, ServletGraniteConfig.getServletConfig(context), ServletServicesConfig.getServletConfig(context));
            }
            if ((jmfInitialization = context.getInitParameter(JMF_INITIALIZATION)) == null || "true".equals(jmfInitialization)) {
                GraniteConfigListener.loadJMFSharedContext(context, gConfig);
            }
            log.info("GraniteDS initialized", new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize Granite environment", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        log.info("Stopping GraniteDS...", new Object[0]);
        List listeners = (List)sce.getServletContext().getAttribute(GRANITE_CONFIG_SHUTDOWN_KEY);
        if (listeners != null) {
            try {
                for (ShutdownListener listener : listeners) {
                    listener.stop();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not destroy Granite environment", e);
            }
        }
        if (ServletParams.get(context, GRANITE_MBEANS_ATTRIBUTE, Boolean.TYPE, Boolean.valueOf(false)).booleanValue()) {
            GraniteMBeanInitializer.unregisterMBeans(context);
        }
        log.info("GraniteDS stopped", new Object[0]);
    }

    public static synchronized void registerShutdownListener(ServletContext context, ShutdownListener listener) {
        ArrayList<ShutdownListener> listeners = (ArrayList<ShutdownListener>)context.getAttribute(GRANITE_CONFIG_SHUTDOWN_KEY);
        if (listeners == null) {
            listeners = new ArrayList<ShutdownListener>();
            context.setAttribute(GRANITE_CONFIG_SHUTDOWN_KEY, listeners);
        }
        listeners.add(listener);
    }

    private static void loadJMFSharedContext(ServletContext servletContext, GraniteConfig graniteConfig) {
        log.info("Loading JMF shared context", new Object[0]);
        List<ExtendedObjectCodec> extendedObjectCodecs = null;
        if (graniteConfig.getJmfExtendedCodecsMode() == GraniteConfig.JMF_EXTENSIONS_MODE.REPLACE) {
            extendedObjectCodecs = graniteConfig.getJmfExtendedCodecs();
        } else {
            extendedObjectCodecs = new ArrayList<ExtendedObjectCodec>();
            if (graniteConfig.getJmfExtendedCodecsMode() == GraniteConfig.JMF_EXTENSIONS_MODE.PREPPEND) {
                extendedObjectCodecs.addAll(graniteConfig.getJmfExtendedCodecs());
            }
            for (ExtendedObjectCodecService service : ServiceLoader.load(ExtendedObjectCodecService.class)) {
                extendedObjectCodecs.addAll(Arrays.asList(service.getExtensions()));
            }
            if (graniteConfig.getJmfExtendedCodecsMode() == GraniteConfig.JMF_EXTENSIONS_MODE.APPEND) {
                extendedObjectCodecs.addAll(graniteConfig.getJmfExtendedCodecs());
            }
        }
        log.debug("Using JMF extended codecs: %s", extendedObjectCodecs);
        List<String> defaultStoredStrings = null;
        if (graniteConfig.getJmfDefaultStoredStringsMode() == GraniteConfig.JMF_EXTENSIONS_MODE.REPLACE) {
            defaultStoredStrings = graniteConfig.getJmfDefaultStoredStrings();
        } else {
            defaultStoredStrings = new ArrayList<String>();
            if (graniteConfig.getJmfDefaultStoredStringsMode() == GraniteConfig.JMF_EXTENSIONS_MODE.PREPPEND) {
                defaultStoredStrings.addAll(graniteConfig.getJmfDefaultStoredStrings());
            }
            defaultStoredStrings.addAll(JMFAMFUtil.AMF_DEFAULT_STORED_STRINGS);
            if (graniteConfig.getJmfDefaultStoredStringsMode() == GraniteConfig.JMF_EXTENSIONS_MODE.APPEND) {
                defaultStoredStrings.addAll(graniteConfig.getJmfDefaultStoredStrings());
            }
        }
        log.debug("Using JMF default stored strings: %s", defaultStoredStrings);
        Reflection reflection = graniteConfig.getJmfReflection();
        log.debug("Using JMF reflection: %s", reflection.getClass().getName());
        DefaultAliasRegistry aliasRegistry = new DefaultAliasRegistry();
        DefaultSharedContext sharedContext = new DefaultSharedContext(new DefaultCodecRegistry(extendedObjectCodecs), defaultStoredStrings, reflection, aliasRegistry);
        servletContext.setAttribute(SHARED_CONTEXT_KEY, (Object)sharedContext);
        DefaultSharedContext dumpSharedContext = new DefaultSharedContext(new DefaultCodecRegistry(), defaultStoredStrings, reflection, aliasRegistry);
        servletContext.setAttribute(DUMP_SHARED_CONTEXT_KEY, (Object)dumpSharedContext);
        log.info("JMF shared context loaded", new Object[0]);
    }

    public static SharedContext getSharedContext(ServletContext servletContext) {
        return (SharedContext)servletContext.getAttribute(SHARED_CONTEXT_KEY);
    }

    public static SharedContext getDumpSharedContext(ServletContext servletContext) {
        return (SharedContext)servletContext.getAttribute(DUMP_SHARED_CONTEXT_KEY);
    }

    public static ServletException newSharedContextNotInitializedException() {
        return new ServletException("JMF shared context not initialized (remove or set to true 'jmf-initialization' param in your web.xml)");
    }

    public void sessionCreated(HttpSessionEvent se) {
        Map sessionMap = (Map)se.getSession().getServletContext().getAttribute(GRANITE_SESSION_MAP);
        if (sessionMap != null) {
            sessionMap.put(se.getSession().getId(), se.getSession());
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        Map sessionMap = (Map)se.getSession().getServletContext().getAttribute(GRANITE_SESSION_MAP);
        if (sessionMap != null) {
            sessionMap.remove(se.getSession().getId());
        }
    }

    public static interface ServiceConfigurator {
        public void initialize(ServletContext var1);

        public void configureServices(ServletContext var1) throws ServletException;
    }
}

