/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import javax.servlet.ServletContext;
import org.granite.config.GraniteConfig;
import org.granite.config.GraniteConfigReloadListener;
import org.granite.gravity.DefaultGravityFactory;
import org.granite.gravity.GravityManager;
import org.granite.util.XMap;

public class GravityConfig
implements GraniteConfigReloadListener {
    public static final String DEFAULT_GRAVITY_FACTORY = DefaultGravityFactory.class.getName();
    public static final long DEFAULT_CHANNEL_IDLE_TIMEOUT_MILLIS = 1800000L;
    public static final long DEFAULT_LONG_POLLING_TIMEOUT_MILLIS = 20000L;
    public static final boolean DEFAULT_RETRY_ON_ERROR = true;
    public static final int DEFAULT_MAX_MESSAGES_QUEUED_PER_CHANNEL = Integer.MAX_VALUE;
    public static final long DEFAULT_RECONNECT_INTERVAL_MILLIS = 30000L;
    public static final int DEFAULT_RECONNECT_MAX_ATTEMPTS = 60;
    public static final int DEFAULT_CORE_POOL_SIZE = 5;
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = 20;
    public static final long DEFAULT_KEEP_ALIVE_TIME_MILLIS = 10000L;
    public static final int DEFAULT_QUEUE_CAPACITY = Integer.MAX_VALUE;
    public static final int DEFAULT_UDP_SEND_BUFFER_SIZE = 65536;
    private String gravityFactory = DEFAULT_GRAVITY_FACTORY;
    private long channelIdleTimeoutMillis = 1800000L;
    private long longPollingTimeoutMillis = 20000L;
    private boolean retryOnError = true;
    private int maxMessagesQueuedPerChannel = Integer.MAX_VALUE;
    private long reconnectIntervalMillis = 30000L;
    private int reconnectMaxAttempts = 60;
    private XMap extra = null;
    private int corePoolSize = 5;
    private int maximumPoolSize = 20;
    private long keepAliveTimeMillis = 10000L;
    private int queueCapacity = Integer.MAX_VALUE;
    private boolean useUdp = false;
    private int udpPort = 0;
    private boolean udpNio = true;
    private boolean udpConnected = true;
    private int udpSendBufferSize = 65536;

    public GravityConfig(GraniteConfig graniteConfig) {
        this.parseConfig(graniteConfig.getGravityConfig());
    }

    private void parseConfig(XMap config) {
        if (config != null) {
            this.gravityFactory = config.get("@factory", String.class, DEFAULT_GRAVITY_FACTORY);
            this.channelIdleTimeoutMillis = config.get("@channel-idle-timeout-millis", Long.TYPE, 1800000L);
            this.longPollingTimeoutMillis = config.get("@long-polling-timeout-millis", Long.TYPE, 20000L);
            this.retryOnError = config.get("@retry-on-error", Boolean.TYPE, true);
            this.maxMessagesQueuedPerChannel = config.get("@max-messages-queued-per-channel", Integer.TYPE, Integer.MAX_VALUE);
            this.reconnectIntervalMillis = config.get("@reconnect-interval-millis", Long.TYPE, 30000L);
            this.reconnectMaxAttempts = config.get("@reconnect-max-attempts", Integer.TYPE, 60);
            this.extra = config.getOne("configuration");
            this.corePoolSize = config.get("thread-pool/@core-pool-size", Integer.TYPE, 5);
            this.maximumPoolSize = config.get("thread-pool/@maximum-pool-size", Integer.TYPE, 20);
            this.keepAliveTimeMillis = config.get("thread-pool/@keep-alive-time-millis", Long.TYPE, 10000L);
            this.queueCapacity = config.get("thread-pool/@queue-capacity", Integer.TYPE, Integer.MAX_VALUE);
            this.useUdp = config.containsKey("udp");
            if (this.useUdp) {
                this.udpPort = config.get("udp/@port", Integer.TYPE, 0);
                this.udpNio = config.get("udp/@nio", Boolean.TYPE, true);
                this.udpConnected = config.get("udp/@connected", Boolean.TYPE, true);
                this.udpSendBufferSize = config.get("udp/@send-buffer-size", Integer.TYPE, 65536);
            }
        }
    }

    @Override
    public void onReload(ServletContext context, GraniteConfig config) {
        this.parseConfig(config.getGravityConfig());
        GravityManager.reconfigure(context, this);
    }

    public String getGravityFactory() {
        return this.gravityFactory;
    }

    public long getChannelIdleTimeoutMillis() {
        return this.channelIdleTimeoutMillis;
    }

    public void setChannelIdleTimeoutMillis(long channelIdleTimeoutMillis) {
        this.channelIdleTimeoutMillis = channelIdleTimeoutMillis;
    }

    public long getLongPollingTimeoutMillis() {
        return this.longPollingTimeoutMillis;
    }

    public void setLongPollingTimeoutMillis(long longPollingTimeoutMillis) {
        this.longPollingTimeoutMillis = longPollingTimeoutMillis;
    }

    public boolean isRetryOnError() {
        return this.retryOnError;
    }

    public void setRetryOnError(boolean retryOnError) {
        this.retryOnError = retryOnError;
    }

    public int getMaxMessagesQueuedPerChannel() {
        return this.maxMessagesQueuedPerChannel;
    }

    public void setMaxMessagesQueuedPerChannel(int maxMessagesQueuedPerChannel) {
        this.maxMessagesQueuedPerChannel = maxMessagesQueuedPerChannel;
    }

    public long getReconnectIntervalMillis() {
        return this.reconnectIntervalMillis;
    }

    public void setReconnectIntervalMillis(long reconnectIntervalMillis) {
        this.reconnectIntervalMillis = reconnectIntervalMillis;
    }

    public int getReconnectMaxAttempts() {
        return this.reconnectMaxAttempts;
    }

    public void setReconnectMaxAttempts(int reconnectMaxAttempts) {
        this.reconnectMaxAttempts = reconnectMaxAttempts;
    }

    public XMap getExtra() {
        return this.extra != null ? this.extra : XMap.EMPTY_XMAP;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public long getKeepAliveTimeMillis() {
        return this.keepAliveTimeMillis;
    }

    public void setKeepAliveTimeMillis(long keepAliveTimeMillis) {
        this.keepAliveTimeMillis = keepAliveTimeMillis;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public boolean isUseUdp() {
        return this.useUdp;
    }

    public void setUseUdp(boolean useUdp) {
        this.useUdp = useUdp;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public void setUdpPort(int udpPort) {
        this.udpPort = udpPort;
    }

    public boolean isUdpNio() {
        return this.udpNio;
    }

    public void setUdpNio(boolean udpNio) {
        this.udpNio = udpNio;
    }

    public boolean isUdpConnected() {
        return this.udpConnected;
    }

    public void setUdpConnected(boolean udpConnected) {
        this.udpConnected = udpConnected;
    }

    public int getUdpSendBufferSize() {
        return this.udpSendBufferSize;
    }

    public void setUdpSendBufferSize(int udpBufferSize) {
        this.udpSendBufferSize = udpBufferSize;
    }
}

