/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.granite.config.GraniteConfig;
import org.granite.config.GraniteConfigListener;
import org.granite.config.ServletGraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.config.flex.ServletServicesConfig;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.GravityFactory;
import org.granite.util.TypeUtil;

public class GravityManager {
    private static final String GRAVITY_KEY = Gravity.class.getName();

    public static Gravity start(ServletConfig servletConfig) throws ServletException {
        return GravityManager.start(servletConfig.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Gravity start(ServletContext context) throws ServletException {
        Gravity gravity = null;
        ServletContext servletContext = context;
        synchronized (servletContext) {
            gravity = (Gravity)context.getAttribute(GRAVITY_KEY);
            if (gravity == null) {
                GraniteConfig graniteConfig = ServletGraniteConfig.loadConfig(context);
                ServicesConfig servicesConfig = ServletServicesConfig.loadConfig(context);
                GravityServiceConfigurator serviceConfigurator = (GravityServiceConfigurator)context.getAttribute("org.granite.config.serverFilter");
                if (serviceConfigurator != null) {
                    serviceConfigurator.configureGravityServices(context);
                }
                GravityConfig gravityConfig = new GravityConfig(graniteConfig);
                String gravityFactory = gravityConfig.getGravityFactory();
                try {
                    GravityFactory factory = TypeUtil.newInstance(gravityFactory, GravityFactory.class);
                    gravity = factory.newGravity(gravityConfig, servicesConfig, graniteConfig);
                }
                catch (Exception e) {
                    throw new ServletException("Could not create Gravity instance with factory: " + gravityFactory, (Throwable)e);
                }
                try {
                    gravity.start();
                    context.setAttribute(GRAVITY_KEY, (Object)gravity);
                    GraniteConfigListener.registerShutdownListener(context, gravity);
                }
                catch (Exception e) {
                    throw new ServletException("Gravity initialization error", (Throwable)e);
                }
            }
        }
        return gravity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reconfigure(ServletContext context, GravityConfig gravityConfig) {
        ServletContext servletContext = context;
        synchronized (servletContext) {
            Gravity gravity = GravityManager.getGravity(context);
            gravity.reconfigure(gravityConfig, ServletGraniteConfig.getConfig(context));
        }
    }

    public static Gravity getGravity(ServletContext context) {
        return (Gravity)context.getAttribute(GRAVITY_KEY);
    }

    public static interface GravityServiceConfigurator {
        public void configureGravityServices(ServletContext var1) throws ServletException;
    }
}

