/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.StandardCodec;
import org.granite.messaging.jmf.codec.std.ArrayCodec;
import org.granite.messaging.jmf.codec.std.IntegerCodec;
import org.granite.messaging.jmf.codec.std.LongCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractIntegerStringCodec;
import org.granite.messaging.jmf.codec.std.impl.DoubleCodecImpl;
import org.granite.messaging.jmf.codec.std.impl.FloatCodecImpl;

public class ArrayCodecImpl
extends AbstractIntegerStringCodec<Object>
implements ArrayCodec {
    @Override
    public int getObjectType() {
        return 3;
    }

    @Override
    public boolean canEncode(Object v) {
        return v.getClass().isArray();
    }

    @Override
    public void encode(OutputContext ctx, Object v) throws IOException {
        int dimensions = this.getArrayDimensions(v);
        Class<?> componentType = this.getComponentType(v);
        int jmfComponentType = ctx.getSharedContext().getCodecRegistry().jmfTypeOfPrimitiveClass(componentType);
        if (jmfComponentType != -1) {
            this.writePrimitiveArray(ctx, v, jmfComponentType, dimensions, true);
        } else {
            this.writeObjectArray(ctx, v, dimensions, true);
        }
    }

    @Override
    public Object decode(InputContext ctx, int parameterizedJmfType) throws IOException, ClassNotFoundException {
        CodecRegistry codecRegistry = ctx.getSharedContext().getCodecRegistry();
        int jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
        if (jmfType != 3) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        Object v = null;
        int indexOrLength = this.readIntData(ctx, parameterizedJmfType >> 4 & 3, false);
        if ((parameterizedJmfType & 0x80) != 0) {
            v = ctx.getSharedObject(indexOrLength);
        } else {
            int dimensions = (parameterizedJmfType & 0x40) == 0 ? 0 : ctx.safeRead();
            int parameterizedJmfComponentType = ctx.safeRead();
            int jmfComponentType = codecRegistry.extractJmfType(parameterizedJmfComponentType);
            Class<?> componentType = codecRegistry.primitiveClassOfJmfType(jmfComponentType);
            v = componentType != null ? this.readPrimitiveArray(ctx, componentType, jmfComponentType, indexOrLength, dimensions) : this.readObjectArray(ctx, parameterizedJmfComponentType, indexOrLength, dimensions);
        }
        return v;
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        CodecRegistry codecRegistry = ctx.getSharedContext().getCodecRegistry();
        int jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
        if (jmfType != 3) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        int indexOrLength = this.readIntData(ctx, parameterizedJmfType >> 4 & 3, false);
        if ((parameterizedJmfType & 0x80) != 0) {
            ctx.indentPrintLn("<" + ctx.getSharedObject(indexOrLength) + "@" + indexOrLength + ">");
        } else {
            int dimensions = (parameterizedJmfType & 0x40) == 0 ? 0 : ctx.safeRead();
            int parameterizedJmfComponentType = ctx.safeRead();
            int jmfComponentType = codecRegistry.extractJmfType(parameterizedJmfComponentType);
            Class<?> componentType = codecRegistry.primitiveClassOfJmfType(jmfComponentType);
            if (componentType != null) {
                this.dumpPrimitiveArray(ctx, componentType, jmfComponentType, indexOrLength, dimensions);
            } else {
                this.dumpObjectArray(ctx, parameterizedJmfComponentType, indexOrLength, dimensions);
            }
        }
    }

    protected void writeObjectArray(OutputContext ctx, Object v, int dimensions, boolean writeDimensions) throws IOException {
        OutputStream os = ctx.getOutputStream();
        if (v == null) {
            os.write(120);
        } else {
            int indexOfStoredObject = ctx.indexOfStoredObjects(v);
            if (indexOfStoredObject >= 0) {
                AbstractIntegerStringCodec.IntegerComponents ics = this.intComponents(indexOfStoredObject);
                ctx.getOutputStream().write(0x80 | ics.length << 4 | 3);
                this.writeIntData(ctx, ics);
            } else {
                ctx.addToStoredObjects(v);
                if (dimensions == 0) {
                    this.writeObjectArray(ctx, v);
                } else {
                    int length = Array.getLength(v);
                    AbstractIntegerStringCodec.IntegerComponents ics = this.intComponents(length);
                    if (writeDimensions) {
                        os.write(0x40 | ics.length << 4 | 3);
                        this.writeIntData(ctx, ics);
                        os.write(dimensions);
                    } else {
                        os.write(ics.length << 4 | 3);
                        this.writeIntData(ctx, ics);
                    }
                    Class<?> componentType = this.getComponentType(v);
                    String className = ctx.getAlias(componentType.getName());
                    this.writeString(ctx, className, JMF_STRING_TYPE_HANDLER);
                    int subDimensions = dimensions - 1;
                    for (int index = 0; index < length; ++index) {
                        this.writeObjectArray(ctx, Array.get(v, index), subDimensions, false);
                    }
                }
            }
        }
    }

    protected void writeObjectArray(OutputContext ctx, Object v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        int length = Array.getLength(v);
        Class<?> componentType = v.getClass().getComponentType();
        String className = ctx.getAlias(componentType.getName());
        AbstractIntegerStringCodec.IntegerComponents ics = this.intComponents(length);
        os.write(ics.length << 4 | 3);
        this.writeIntData(ctx, ics);
        this.writeString(ctx, className, JMF_STRING_TYPE_HANDLER);
        for (int index = 0; index < length; ++index) {
            ctx.writeObject(Array.get(v, index));
        }
    }

    protected void writePrimitiveArray(OutputContext ctx, Object v, int jmfComponentType, int dimensions, boolean writeDimensionsAndType) throws IOException {
        OutputStream os = ctx.getOutputStream();
        if (v == null) {
            os.write(120);
        } else {
            int indexOfStoredObject = ctx.indexOfStoredObjects(v);
            if (indexOfStoredObject >= 0) {
                AbstractIntegerStringCodec.IntegerComponents ics = this.intComponents(indexOfStoredObject);
                ctx.getOutputStream().write(0x80 | ics.length << 4 | 3);
                this.writeIntData(ctx, ics);
            } else {
                ctx.addToStoredObjects(v);
                if (dimensions == 0) {
                    this.writePrimitiveArray(ctx, v, jmfComponentType, writeDimensionsAndType);
                } else {
                    int length = Array.getLength(v);
                    AbstractIntegerStringCodec.IntegerComponents ics = this.intComponents(length);
                    if (writeDimensionsAndType) {
                        os.write(0x40 | ics.length << 4 | 3);
                        this.writeIntData(ctx, ics);
                        os.write(dimensions);
                        os.write(jmfComponentType);
                    } else {
                        os.write(ics.length << 4 | 3);
                        this.writeIntData(ctx, ics);
                    }
                    int subDimensions = dimensions - 1;
                    for (int index = 0; index < length; ++index) {
                        this.writePrimitiveArray(ctx, Array.get(v, index), jmfComponentType, subDimensions, false);
                    }
                }
            }
        }
    }

    protected void writePrimitiveArray(OutputContext ctx, Object v, int jmfComponentType, boolean writeType) throws IOException {
        OutputStream os = ctx.getOutputStream();
        int length = Array.getLength(v);
        AbstractIntegerStringCodec.IntegerComponents ics = this.intComponents(length);
        os.write(ics.length << 4 | 3);
        this.writeIntData(ctx, ics);
        if (writeType) {
            os.write(jmfComponentType);
        }
        if (length == 0) {
            return;
        }
        switch (jmfComponentType) {
            case 56: {
                byte[] bytes = new byte[this.lengthOfBooleanArray(length)];
                int i = 0;
                int j = 0;
                for (boolean b : (boolean[])v) {
                    if (b) {
                        int n = i;
                        bytes[n] = (byte)(bytes[n] | 128 >> j);
                    }
                    if (++j < 8) continue;
                    j = 0;
                    ++i;
                }
                os.write(bytes);
                break;
            }
            case 58: {
                char[] a;
                for (char c : a = (char[])v) {
                    os.write(c >> 8);
                    os.write(c);
                }
                break;
            }
            case 122: {
                os.write((byte[])v);
                break;
            }
            case 24: {
                short[] a;
                for (short s : a = (short[])v) {
                    os.write(s >> 8);
                    os.write(s);
                }
                break;
            }
            case 8: {
                int[] a;
                IntegerCodec integerCodec = ctx.getSharedContext().getCodecRegistry().getIntegerCodec();
                for (int i : a = (int[])v) {
                    integerCodec.writeVariableInt(ctx, i);
                }
                break;
            }
            case 4: {
                long[] a;
                LongCodec longCodec = ctx.getSharedContext().getCodecRegistry().getLongCodec();
                for (long l : a = (long[])v) {
                    longCodec.writeVariableLong(ctx, l);
                }
                break;
            }
            case 124: {
                float[] a;
                for (float f : a = (float[])v) {
                    int bits = Float.floatToIntBits(f);
                    os.write(bits);
                    os.write(bits >> 8);
                    os.write(bits >> 16);
                    os.write(bits >> 24);
                }
                break;
            }
            case 28: {
                double[] a;
                for (double d : a = (double[])v) {
                    long bits = Double.doubleToLongBits(d);
                    os.write((int)bits);
                    os.write((int)(bits >> 8));
                    os.write((int)(bits >> 16));
                    os.write((int)(bits >> 24));
                    os.write((int)(bits >> 32));
                    os.write((int)(bits >> 40));
                    os.write((int)(bits >> 48));
                    os.write((int)(bits >> 56));
                }
                break;
            }
            default: {
                throw new JMFEncodingException("Unsupported primitive type: " + jmfComponentType);
            }
        }
    }

    protected int getArrayDimensions(Object v) {
        return v.getClass().getName().lastIndexOf(91);
    }

    protected Class<?> getComponentType(Object v) {
        Class<?> componentType = v.getClass().getComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        return componentType;
    }

    protected Object readObjectArray(InputContext ctx, int parameterizedJmfComponentType, int length, int dimensions) throws IOException, ClassNotFoundException {
        Object v = null;
        String componentTypeName = this.readString(ctx, parameterizedJmfComponentType, JMF_STRING_TYPE_HANDLER);
        componentTypeName = ctx.getAlias(componentTypeName);
        Class<?> componentType = ctx.getSharedContext().getReflection().loadClass(componentTypeName);
        if (dimensions == 0) {
            v = this.readObjectArray(ctx, componentType, length);
        } else {
            v = this.newArray(componentType, length, dimensions);
            ctx.addSharedObject(v);
            int subDimensions = dimensions - 1;
            for (int index = 0; index < length; ++index) {
                int subParameterizedJmfType = ctx.safeRead();
                int subJmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(subParameterizedJmfType);
                if (subJmfType == 120) {
                    Array.set(v, index, null);
                    continue;
                }
                if (subJmfType == 3) {
                    int subLengthOrIndex = this.readIntData(ctx, subParameterizedJmfType >> 4 & 3, false);
                    if ((subParameterizedJmfType & 0x80) != 0) {
                        Array.set(v, index, ctx.getSharedObject(subLengthOrIndex));
                        continue;
                    }
                    int subParameterizedJmfComponentType = ctx.safeRead();
                    Array.set(v, index, this.readObjectArray(ctx, subParameterizedJmfComponentType, subLengthOrIndex, subDimensions));
                    continue;
                }
                this.newBadTypeJMFEncodingException(subJmfType, subParameterizedJmfType);
            }
        }
        return v;
    }

    protected void dumpObjectArray(DumpContext ctx, int parameterizedJmfComponentType, int length, int dimensions) throws IOException {
        String componentTypeName = this.readString(ctx, parameterizedJmfComponentType, JMF_STRING_TYPE_HANDLER);
        if (dimensions == 0) {
            this.dumpObjectArray(ctx, componentTypeName, length);
        } else {
            String v = this.newDumpObjectArray(componentTypeName, length, dimensions);
            int indexOfStoredObject = ctx.addSharedObject(v);
            ctx.indentPrintLn(v + "@" + indexOfStoredObject + ": {");
            ctx.incrIndent(1);
            int subDimensions = dimensions - 1;
            for (int index = 0; index < length; ++index) {
                int subParameterizedJmfType = ctx.safeRead();
                int subJmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(subParameterizedJmfType);
                if (subJmfType == 120) {
                    ctx.indentPrintLn("null");
                    continue;
                }
                if (subJmfType == 3) {
                    int subLengthOrIndex = this.readIntData(ctx, subParameterizedJmfType >> 4 & 3, false);
                    if ((subParameterizedJmfType & 0x80) != 0) {
                        ctx.indentPrintLn("<" + ctx.getSharedObject(subLengthOrIndex) + "@" + subLengthOrIndex + ">");
                        continue;
                    }
                    int subParameterizedJmfComponentType = ctx.safeRead();
                    this.dumpObjectArray(ctx, subParameterizedJmfComponentType, subLengthOrIndex, subDimensions);
                    continue;
                }
                this.newBadTypeJMFEncodingException(subJmfType, subParameterizedJmfType);
            }
            ctx.incrIndent(-1);
            ctx.indentPrintLn("}");
        }
    }

    protected Object readObjectArray(InputContext ctx, Class<?> componentType, int length) throws IOException, ClassNotFoundException {
        Object v = Array.newInstance(componentType, length);
        ctx.addSharedObject(v);
        for (int index = 0; index < length; ++index) {
            Array.set(v, index, ctx.readObject());
        }
        return v;
    }

    protected void dumpObjectArray(DumpContext ctx, String componentTypeName, int length) throws IOException {
        String v = this.newDumpObjectArray(componentTypeName, length, 0);
        int indexOfStoredObject = ctx.addSharedObject(v);
        ctx.indentPrintLn(v + "@" + indexOfStoredObject + ": {");
        ctx.incrIndent(1);
        for (int index = 0; index < length; ++index) {
            int parameterizedJmfType = ctx.safeRead();
            int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
            StandardCodec codec = ctx.getSharedContext().getCodecRegistry().getCodec(jmfType);
            if (codec == null) {
                throw new JMFEncodingException("No codec for JMF type: " + jmfType);
            }
            codec.dump(ctx, parameterizedJmfType);
        }
        ctx.incrIndent(-1);
        ctx.indentPrintLn("}");
    }

    protected String newDumpObjectArray(String componentTypeName, int length, int dimensions) {
        StringBuilder sb = new StringBuilder(componentTypeName);
        sb.append('[').append(length).append(']');
        for (int i = 0; i < dimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    protected Object readPrimitiveArray(InputContext ctx, Class<?> componentType, int jmfComponentType, int length, int dimensions) throws IOException {
        Object v = null;
        if (dimensions == 0) {
            v = this.readPrimitiveArray(ctx, componentType, jmfComponentType, length);
        } else {
            v = this.newArray(componentType, length, dimensions);
            ctx.addSharedObject(v);
            int subDimensions = dimensions - 1;
            for (int index = 0; index < length; ++index) {
                int subArrayJmfType = ctx.safeRead();
                if (subArrayJmfType == 120) {
                    Array.set(v, index, null);
                    continue;
                }
                int subLengthOrIndex = this.readIntData(ctx, subArrayJmfType >> 4 & 3, false);
                if ((subArrayJmfType & 0x80) != 0) {
                    Array.set(v, index, ctx.getSharedObject(subLengthOrIndex));
                    continue;
                }
                Array.set(v, index, this.readPrimitiveArray(ctx, componentType, jmfComponentType, subLengthOrIndex, subDimensions));
            }
        }
        return v;
    }

    protected void dumpPrimitiveArray(DumpContext ctx, Class<?> componentType, int jmfComponentType, int length, int dimensions) throws IOException {
        if (dimensions == 0) {
            this.dumpPrimitiveArray(ctx, componentType, jmfComponentType, length);
        } else {
            String v = this.newDumpPrimitiveArray(jmfComponentType, length, dimensions);
            int indexOfStoredObject = ctx.addSharedObject(v);
            ctx.indentPrintLn(v + "@" + indexOfStoredObject + ": {");
            ctx.incrIndent(1);
            int subDimensions = dimensions - 1;
            for (int index = 0; index < length; ++index) {
                int subArrayJmfType = ctx.safeRead();
                if (subArrayJmfType == 120) {
                    ctx.indentPrintLn("null");
                    continue;
                }
                int subLengthOrIndex = this.readIntData(ctx, subArrayJmfType >> 4 & 3, false);
                if ((subArrayJmfType & 0x80) != 0) {
                    ctx.indentPrintLn("<" + ctx.getSharedObject(subLengthOrIndex) + "@" + subLengthOrIndex + ">");
                    continue;
                }
                this.dumpPrimitiveArray(ctx, componentType, jmfComponentType, subLengthOrIndex, subDimensions);
            }
            ctx.incrIndent(-1);
            ctx.indentPrintLn("}");
        }
    }

    protected Object readPrimitiveArray(InputContext ctx, Class<?> componentType, int jmfComponentType, int length) throws IOException {
        Object v = null;
        if (length == 0) {
            v = Array.newInstance(componentType, length);
        } else {
            switch (jmfComponentType) {
                case 56: {
                    boolean[] a = new boolean[length];
                    int nb = this.lengthOfBooleanArray(length);
                    for (int i = 0; i < nb; ++i) {
                        int index;
                        int b = ctx.safeRead();
                        for (int j = 0; j < 8 && (index = i * 8 + j) < length; ++j) {
                            a[index] = (b & 128 >> j) != 0;
                        }
                    }
                    v = a;
                    break;
                }
                case 58: {
                    char[] a = new char[length];
                    for (int i = 0; i < length; ++i) {
                        a[i] = (char)(ctx.safeRead() << 8 | ctx.safeRead());
                    }
                    v = a;
                    break;
                }
                case 122: {
                    byte[] a = new byte[length];
                    ctx.safeReadFully(a);
                    v = a;
                    break;
                }
                case 24: {
                    short[] a = new short[length];
                    for (int i = 0; i < length; ++i) {
                        a[i] = (short)(ctx.safeRead() << 8 | ctx.safeRead());
                    }
                    v = a;
                    break;
                }
                case 8: {
                    IntegerCodec integerCodec = ctx.getSharedContext().getCodecRegistry().getIntegerCodec();
                    int[] a = new int[length];
                    for (int i = 0; i < length; ++i) {
                        a[i] = integerCodec.readVariableInt(ctx);
                    }
                    v = a;
                    break;
                }
                case 4: {
                    LongCodec longCodec = ctx.getSharedContext().getCodecRegistry().getLongCodec();
                    long[] a = new long[length];
                    for (int i = 0; i < length; ++i) {
                        a[i] = longCodec.readVariableLong(ctx);
                    }
                    v = a;
                    break;
                }
                case 124: {
                    float[] a = new float[length];
                    for (int i = 0; i < length; ++i) {
                        a[i] = FloatCodecImpl.readFloatData(ctx, jmfComponentType);
                    }
                    v = a;
                    break;
                }
                case 28: {
                    double[] a = new double[length];
                    for (int i = 0; i < length; ++i) {
                        a[i] = DoubleCodecImpl.readDoubleData(ctx, jmfComponentType);
                    }
                    v = a;
                    break;
                }
                default: {
                    throw new JMFEncodingException("Unsupported primitive type: " + jmfComponentType);
                }
            }
        }
        ctx.addSharedObject(v);
        return v;
    }

    protected void dumpPrimitiveArray(DumpContext ctx, Class<?> componentType, int jmfComponentType, int length) throws IOException {
        String v = this.newDumpPrimitiveArray(jmfComponentType, length, 0);
        int indexOfStoredObject = ctx.addSharedObject(v);
        ctx.indentPrint(v + "@" + indexOfStoredObject + ": {");
        switch (jmfComponentType) {
            case 56: {
                int nb = this.lengthOfBooleanArray(length);
                for (int i = 0; i < nb; ++i) {
                    int index;
                    int b = ctx.safeRead();
                    for (int j = 0; j < 8 && (index = i * 8 + j) < length; ++j) {
                        if (index > 0) {
                            ctx.print(", ");
                        }
                        ctx.print(String.valueOf((b & 128 >> j) != 0));
                    }
                }
                break;
            }
            case 58: {
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        ctx.print(", ");
                    }
                    ctx.print(String.valueOf((char)(ctx.safeRead() << 8 | ctx.safeRead())));
                }
                break;
            }
            case 122: {
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        ctx.print(", ");
                    }
                    ctx.print(String.valueOf((byte)ctx.safeRead()));
                }
                break;
            }
            case 24: {
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        ctx.print(", ");
                    }
                    ctx.print(String.valueOf((short)(ctx.safeRead() << 8) | ctx.safeRead()));
                }
                break;
            }
            case 8: {
                IntegerCodec integerCodec = ctx.getSharedContext().getCodecRegistry().getIntegerCodec();
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        ctx.print(", ");
                    }
                    ctx.print(String.valueOf(integerCodec.readVariableInt(ctx)));
                }
                break;
            }
            case 4: {
                LongCodec longCodec = ctx.getSharedContext().getCodecRegistry().getLongCodec();
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        ctx.print(", ");
                    }
                    ctx.print(String.valueOf(longCodec.readVariableLong(ctx)));
                }
                break;
            }
            case 124: {
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        ctx.print(", ");
                    }
                    ctx.print(String.valueOf(FloatCodecImpl.readFloatData(ctx, jmfComponentType)));
                }
                break;
            }
            case 28: {
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        ctx.print(", ");
                    }
                    ctx.print(String.valueOf(DoubleCodecImpl.readDoubleData(ctx, jmfComponentType)));
                }
                break;
            }
            default: {
                throw new JMFEncodingException("Unsupported primitive type: " + jmfComponentType);
            }
        }
        ctx.noIndentPrintLn("}");
    }

    protected String newDumpPrimitiveArray(int jmfComponentType, int length, int dimensions) throws IOException {
        StringBuilder sb = new StringBuilder();
        switch (jmfComponentType) {
            case 56: {
                sb.append("boolean");
                break;
            }
            case 58: {
                sb.append("char");
                break;
            }
            case 122: {
                sb.append("byte");
                break;
            }
            case 24: {
                sb.append("short");
                break;
            }
            case 8: {
                sb.append("int");
                break;
            }
            case 4: {
                sb.append("long");
                break;
            }
            case 124: {
                sb.append("float");
                break;
            }
            case 28: {
                sb.append("double");
                break;
            }
            default: {
                throw new JMFEncodingException("Unsupported primitive type: " + jmfComponentType);
            }
        }
        sb.append('[').append(length).append(']');
        for (int i = 0; i < dimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    protected Object newArray(Class<?> type, int length, int dimensions) {
        int[] ld = new int[dimensions + 1];
        ld[0] = length;
        return Array.newInstance(type, ld);
    }

    protected int lengthOfBooleanArray(int nb) {
        return nb / 8 + (nb % 8 != 0 ? 1 : 0);
    }
}

