/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.BigIntegerCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractIntegerStringCodec;

public class BigIntegerCodecImpl
extends AbstractIntegerStringCodec<BigInteger>
implements BigIntegerCodec {
    @Override
    public int getObjectType() {
        return 26;
    }

    @Override
    public Class<?> getObjectClass() {
        return BigInteger.class;
    }

    @Override
    public void encode(OutputContext ctx, BigInteger v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        ctx.addToStoredObjects(v);
        byte[] magnitude = v.toByteArray();
        AbstractIntegerStringCodec.IntegerComponents ics = this.intComponents(magnitude.length);
        os.write(ics.length << 6 | 0x1A);
        this.writeIntData(ctx, ics);
        os.write(magnitude);
    }

    @Override
    public BigInteger decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 26) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        int magnitudeLength = this.readIntData(ctx, parameterizedJmfType >> 6 & 3, false);
        byte[] magnitude = new byte[magnitudeLength];
        ctx.safeReadFully(magnitude);
        BigInteger v = new BigInteger(magnitude);
        if (BigInteger.ZERO.equals(v)) {
            v = BigInteger.ZERO;
        } else if (BigInteger.ONE.equals(v)) {
            v = BigInteger.ONE;
        } else if (BigInteger.TEN.equals(v)) {
            v = BigInteger.TEN;
        }
        return v;
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 26) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        ctx.indentPrintLn(BigInteger.class.getName() + ": " + this.decode(ctx, parameterizedJmfType));
    }
}

