/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.granite.messaging.reflect.BypassConstructorAllocator;

public class SunBypassConstructorAllocator
implements BypassConstructorAllocator {
    private final Object reflectionFactory;
    private final Method newConstructorForSerialization;
    private final Constructor<?> objectConstructor;

    public SunBypassConstructorAllocator() throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> reflectionFactoryClass = Thread.currentThread().getContextClassLoader().loadClass("sun.reflect.ReflectionFactory");
        this.reflectionFactory = reflectionFactoryClass.getDeclaredMethod("getReflectionFactory", new Class[0]).invoke(null, new Object[0]);
        this.newConstructorForSerialization = reflectionFactoryClass.getDeclaredMethod("newConstructorForSerialization", Class.class, Constructor.class);
        this.objectConstructor = Object.class.getDeclaredConstructor(new Class[0]);
    }

    @Override
    public <T> T newInstance(Class<T> cls) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Constructor constructor = (Constructor)this.newConstructorForSerialization.invoke(this.reflectionFactory, cls, this.objectConstructor);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }
}

