/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.adapters;

import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.util.concurrent.ConcurrentHashMap;
import org.granite.gravity.AsyncPublishedMessage;
import org.granite.gravity.Channel;
import org.granite.gravity.MessagePublishingException;
import org.granite.gravity.adapters.ServiceAdapter;
import org.granite.gravity.adapters.Topic;
import org.granite.gravity.adapters.TopicId;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.util.XMap;

public class SimpleServiceAdapter
extends ServiceAdapter {
    private static final Logger log = Logger.getLogger(SimpleServiceAdapter.class);
    private final Topic rootTopic = new Topic("/", this);
    private transient ConcurrentHashMap<String, TopicId> _topicIdCache;
    private boolean noLocal = false;

    @Override
    public void configure(XMap adapterProperties, XMap destinationProperties) throws ServiceException {
        super.configure(adapterProperties, destinationProperties);
        this._topicIdCache = new ConcurrentHashMap();
        if (Boolean.TRUE.toString().equals(destinationProperties.get("no-local"))) {
            this.noLocal = true;
        }
    }

    public Topic getTopic(TopicId id) {
        return this.rootTopic.getChild(id);
    }

    public Topic getTopic(String id) {
        TopicId cid = this.getTopicId(id);
        if (cid.depth() == 0) {
            return null;
        }
        return this.rootTopic.getChild(cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic getTopic(String id, boolean create) {
        SimpleServiceAdapter simpleServiceAdapter = this;
        synchronized (simpleServiceAdapter) {
            Topic topic = this.getTopic(id);
            if (topic == null && create) {
                topic = new Topic(id, this);
                this.rootTopic.addChild(topic);
                log.debug("New Topic: %s", topic);
            }
            return topic;
        }
    }

    public TopicId getTopicId(String id) {
        TopicId tmpTid;
        TopicId tid = this._topicIdCache.get(id);
        if (tid == null && (tmpTid = this._topicIdCache.putIfAbsent(id, tid = new TopicId(id))) != null) {
            tid = tmpTid;
        }
        return tid;
    }

    public boolean hasTopic(String id) {
        TopicId cid = this.getTopicId(id);
        return this.rootTopic.getChild(cid) != null;
    }

    @Override
    public Object invoke(Channel fromChannel, AsyncMessage message) {
        String topicId = TopicId.normalize((String)message.getHeader("DSSubtopic"));
        AcknowledgeMessage reply = null;
        if (this.getSecurityPolicy().canPublish(fromChannel, topicId, message)) {
            TopicId tid = this.getTopicId(topicId);
            try {
                fromChannel.publish(new AsyncPublishedMessage(this.rootTopic, tid, message));
                reply = new AcknowledgeMessage(message);
                reply.setMessageId(message.getMessageId());
            }
            catch (MessagePublishingException e) {
                log.error(e, "Error while publishing message: %s from channel %s to topic: %s", message, fromChannel, tid);
                reply = new ErrorMessage((Message)message, null);
                ((ErrorMessage)reply).setFaultString("Server.Publish.Error");
            }
        } else {
            log.warn("Channel %s tried to publish a message to topic %s", fromChannel, topicId);
            reply = new ErrorMessage((Message)message, null);
            ((ErrorMessage)reply).setFaultString("Server.Publish.Denied");
        }
        return reply;
    }

    @Override
    public Object manage(Channel fromChannel, CommandMessage message) {
        AcknowledgeMessage reply = null;
        if (message.getOperation() == 0) {
            String subscribeTopicId = TopicId.normalize((String)message.getHeader("DSSubtopic"));
            if (this.getSecurityPolicy().canSubscribe(fromChannel, subscribeTopicId, message)) {
                Topic topic = this.getTopic(subscribeTopicId);
                if (topic == null && this.getSecurityPolicy().canCreate(fromChannel, subscribeTopicId, message)) {
                    topic = this.getTopic(subscribeTopicId, true);
                }
                if (topic != null) {
                    String subscriptionId = (String)message.getHeader("DSDstClientId");
                    String selector = (String)message.getHeader("DSSelector");
                    if (subscriptionId == null) {
                        log.warn("No subscriptionId for subscription message", new Object[0]);
                    } else {
                        topic.subscribe(fromChannel, message.getDestination(), subscriptionId, selector, this.noLocal);
                    }
                    reply = new AcknowledgeMessage(message);
                } else {
                    reply = new ErrorMessage((Message)message, null);
                    ((ErrorMessage)reply).setFaultString("Server.CreateTopic.Denied");
                }
            } else {
                reply = new ErrorMessage((Message)message, null);
                ((ErrorMessage)reply).setFaultString("Server.Subscribe.Denied");
            }
        } else if (message.getOperation() == 1) {
            String unsubscribeTopicId = TopicId.normalize((String)message.getHeader("DSSubtopic"));
            Topic topic = this.getTopic(unsubscribeTopicId);
            String subscriptionId = null;
            if (topic != null) {
                subscriptionId = (String)message.getHeader("DSDstClientId");
                if (subscriptionId == null) {
                    log.warn("No subscriptionId for unsubscription message", new Object[0]);
                } else {
                    topic.unsubscribe(fromChannel, subscriptionId);
                }
            }
            reply = new AcknowledgeMessage(message);
            reply.setHeader("DSDstClientId", subscriptionId);
        } else {
            reply = new ErrorMessage((Message)message, null);
            ((ErrorMessage)reply).setFaultString("unknown operation");
        }
        return reply;
    }
}

