/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.types;

import java.io.Externalizable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.types.AMFBasicVectorObjectAliaser;
import org.granite.messaging.amf.types.AMFDictionary;
import org.granite.messaging.amf.types.AMFDictionaryValue;
import org.granite.messaging.amf.types.AMFVectorInt;
import org.granite.messaging.amf.types.AMFVectorIntValue;
import org.granite.messaging.amf.types.AMFVectorNumber;
import org.granite.messaging.amf.types.AMFVectorNumberValue;
import org.granite.messaging.amf.types.AMFVectorObject;
import org.granite.messaging.amf.types.AMFVectorObjectAliaser;
import org.granite.messaging.amf.types.AMFVectorObjectValue;
import org.granite.messaging.amf.types.AMFVectorUint;
import org.granite.messaging.amf.types.AMFVectorUintValue;
import org.granite.util.TypeUtil;

public class AMFSpecialValueFactory {
    protected final AMFVectorObjectAliaser vectorObjectAlias;

    public AMFSpecialValueFactory() {
        this(null);
    }

    public AMFSpecialValueFactory(AMFVectorObjectAliaser vectorObjectAlias) {
        this.vectorObjectAlias = vectorObjectAlias != null ? vectorObjectAlias : new AMFBasicVectorObjectAliaser();
    }

    public Object createSpecialValue(Property property, Object o) {
        if (o != null && !(o instanceof Externalizable)) {
            if (o instanceof Collection || o.getClass().isArray() && o.getClass().getComponentType() != Byte.TYPE) {
                if (property.isAnnotationPresent(AMFVectorInt.class)) {
                    return new AMFVectorIntValue(o, property.getAnnotation(AMFVectorInt.class).fixed());
                }
                if (property.isAnnotationPresent(AMFVectorNumber.class)) {
                    return new AMFVectorNumberValue(o, property.getAnnotation(AMFVectorNumber.class).fixed());
                }
                if (property.isAnnotationPresent(AMFVectorUint.class)) {
                    return new AMFVectorUintValue(o, property.getAnnotation(AMFVectorUint.class).fixed());
                }
                if (property.isAnnotationPresent(AMFVectorObject.class)) {
                    AMFVectorObject annotation = property.getAnnotation(AMFVectorObject.class);
                    String type = annotation.type();
                    if (type == null || type.length() == 0) {
                        Type propertyType = property.getType();
                        Class<?> componentClass = TypeUtil.componentClassOfType(propertyType);
                        type = this.vectorObjectAlias.aliasFor(componentClass);
                    }
                    return new AMFVectorObjectValue(o, type, annotation.fixed());
                }
            } else if (o instanceof Map && property.isAnnotationPresent(AMFDictionary.class)) {
                return new AMFDictionaryValue((Map)o, property.getAnnotation(AMFDictionary.class).weakKeys());
            }
        }
        return o;
    }
}

