/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.reflect.ClassDescriptor;
import org.granite.messaging.reflect.Property;

public class JMFObjectOutputStream
extends ObjectOutputStream {
    private final OutputContext out;
    private final ClassDescriptor desc;
    private final Object v;

    public JMFObjectOutputStream(OutputContext out, ClassDescriptor desc, Object v) throws IOException {
        this.out = out;
        this.desc = desc;
        this.v = v;
    }

    @Override
    protected void writeObjectOverride(Object obj) throws IOException {
        this.out.writeObject(obj);
    }

    @Override
    public void useProtocolVersion(int version) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUnshared(Object obj) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void defaultWriteObject() throws IOException {
        for (Property property : this.desc.getSerializableProperties()) {
            try {
                this.out.getAndWriteProperty(this.v, property);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (InvocationTargetException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public ObjectOutputStream.PutField putFields() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeFields() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(int val) throws IOException {
        this.out.write(val);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.out.write(buf);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void writeBoolean(boolean val) throws IOException {
        this.out.writeBoolean(val);
    }

    @Override
    public void writeByte(int val) throws IOException {
        this.out.writeByte(val);
    }

    @Override
    public void writeShort(int val) throws IOException {
        this.out.writeShort(val);
    }

    @Override
    public void writeChar(int val) throws IOException {
        this.out.writeChar(val);
    }

    @Override
    public void writeInt(int val) throws IOException {
        this.out.writeInt(val);
    }

    @Override
    public void writeLong(long val) throws IOException {
        this.out.writeLong(val);
    }

    @Override
    public void writeFloat(float val) throws IOException {
        this.out.writeFloat(val);
    }

    @Override
    public void writeDouble(double val) throws IOException {
        this.out.writeDouble(val);
    }

    @Override
    public void writeBytes(String str) throws IOException {
        this.out.writeBytes(str);
    }

    @Override
    public void writeChars(String str) throws IOException {
        this.out.writeChars(str);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.out.writeUTF(str);
    }
}

