/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.IntegerCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;
import org.granite.messaging.jmf.codec.std.impl.util.IntegerUtil;

public class IntegerCodecImpl
extends AbstractStandardCodec<Integer>
implements IntegerCodec {
    protected static final int LENGTH_BYTE_COUNT_OFFSET = 5;

    @Override
    public int getObjectType() {
        return 9;
    }

    @Override
    public Class<?> getObjectClass() {
        return Integer.class;
    }

    @Override
    public int getPrimitiveType() {
        return 8;
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Integer.TYPE;
    }

    @Override
    public void encode(OutputContext ctx, Integer v) throws IOException {
        this.writeIntData(ctx, 9, v);
    }

    @Override
    public Integer decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        return this.readIntData(ctx, parameterizedJmfType);
    }

    @Override
    public void encodePrimitive(OutputContext ctx, int v) throws IOException {
        this.writeIntData(ctx, 8, v);
    }

    @Override
    public int decodePrimitive(InputContext ctx) throws IOException {
        int parameterizedJmfType = ctx.safeRead();
        return this.readIntData(ctx, parameterizedJmfType);
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 8: {
                ctx.indentPrintLn("int: " + this.readIntData(ctx, parameterizedJmfType));
                break;
            }
            case 9: {
                ctx.indentPrintLn(Integer.class.getName() + ": " + Integer.valueOf(this.readIntData(ctx, parameterizedJmfType)));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }

    protected void writeIntData(OutputContext ctx, int jmfType, int v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        int opposite = 0;
        if (v < 0 && v != Integer.MIN_VALUE) {
            opposite = 128;
            v = -v;
        }
        int count = IntegerUtil.significantIntegerBytesCount0(v);
        os.write(opposite | count << 5 | jmfType);
        IntegerUtil.encodeInteger(ctx, v, count);
    }

    protected int readIntData(InputContext ctx, int parameterizedJmfType) throws IOException {
        int v = IntegerUtil.decodeInteger(ctx, parameterizedJmfType >>> 5 & 3);
        if ((parameterizedJmfType & 0x80) != 0) {
            v = -v;
        }
        return v;
    }
}

