/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.granite.config.GraniteConfig;
import org.granite.config.GraniteConfigReloadListener;
import org.granite.config.ServletGraniteConfigMBean;
import org.granite.config.api.Configuration;
import org.granite.context.GraniteContext;
import org.granite.jmx.MBeanUtil;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.convert.Converter;
import org.granite.messaging.amf.io.util.ActionScriptClassDescriptor;
import org.granite.messaging.amf.io.util.JavaClassDescriptor;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.util.ServletParams;
import org.granite.util.StreamUtil;

public class ServletGraniteConfig
implements ServletGraniteConfigMBean {
    private static final Logger log = Logger.getLogger(ServletGraniteConfig.class);
    private static final String GRANITE_CONFIG_DEFAULT = "/WEB-INF/granite/granite-config.xml";
    public static final String GRANITE_CONFIG_KEY = GraniteConfig.class.getName() + "_CACHE";
    public static final String GRANITE_CONFIG_DEFAULT_KEY = GraniteConfig.class.getName() + "_DEFAULT";
    public static final String GRANITE_CONFIG_CONFIGURATION_KEY = GraniteConfig.class.getName() + "_CONFIG";
    private GraniteConfig config = null;
    private ServletContext context = null;
    private boolean registerMBeans = false;
    private final List<GraniteConfigReloadListener> reloadListeners = new ArrayList<GraniteConfigReloadListener>();

    private ServletGraniteConfig(ServletContext context, GraniteConfig config) {
        this.context = context;
        this.config = config;
    }

    public static synchronized GraniteConfig getConfig(ServletContext context) {
        return ((ServletGraniteConfig)context.getAttribute((String)ServletGraniteConfig.GRANITE_CONFIG_KEY)).config;
    }

    public static synchronized ServletGraniteConfig getServletConfig(ServletContext context) {
        return (ServletGraniteConfig)context.getAttribute(GRANITE_CONFIG_KEY);
    }

    public static synchronized GraniteConfig loadConfig(ServletContext context) throws ServletException {
        ServletGraniteConfig servletGraniteConfig = (ServletGraniteConfig)context.getAttribute(GRANITE_CONFIG_KEY);
        if (servletGraniteConfig == null) {
            String path = ServletGraniteConfig.getCustomConfigPath(context);
            InputStream is = context.getResourceAsStream(path);
            if (is == null) {
                log.warn("Could not load custom granite-config.xml: %s (file does not exists)", path);
                path = null;
            }
            Configuration configuration = (Configuration)context.getAttribute(GRANITE_CONFIG_CONFIGURATION_KEY);
            String stdConfigPath = (String)context.getAttribute(GRANITE_CONFIG_DEFAULT_KEY);
            boolean registerMBeans = ServletParams.get(context, "registerGraniteMBeans", Boolean.TYPE, Boolean.valueOf(false));
            try {
                String mbeanContextName = null;
                if (registerMBeans) {
                    mbeanContextName = (String)ServletContext.class.getMethod("getContextPath", new Class[0]).invoke((Object)context, new Object[0]);
                }
                ServletGraniteContext.createThreadInstance(null, null, context, (String)null, null);
                GraniteConfig graniteConfig = new GraniteConfig(stdConfigPath, is, configuration, mbeanContextName);
                servletGraniteConfig = ServletGraniteConfig.loadConfig(context, graniteConfig);
            }
            catch (Exception e) {
                log.error(e, "Could not load granite-config.xml", new Object[0]);
                throw new ServletException("Could not load custom granite-config.xml", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
                GraniteContext.release();
            }
        }
        return servletGraniteConfig.config;
    }

    public static synchronized ServletGraniteConfig loadConfig(ServletContext context, GraniteConfig graniteConfig) {
        ServletGraniteConfig servletGraniteConfig = new ServletGraniteConfig(context, graniteConfig);
        context.setAttribute(GRANITE_CONFIG_KEY, (Object)servletGraniteConfig);
        return servletGraniteConfig;
    }

    private static String getCustomConfigPath(ServletContext context) {
        String path = null;
        Configuration configuration = (Configuration)context.getAttribute(GRANITE_CONFIG_CONFIGURATION_KEY);
        if (configuration != null) {
            path = configuration.getGraniteConfig();
        }
        if (path == null) {
            path = ServletParams.get(context, "graniteConfigPath", String.class, GRANITE_CONFIG_DEFAULT);
        }
        return path;
    }

    @Override
    public String getCustomConfigPath() {
        return ServletGraniteConfig.getCustomConfigPath(this.context);
    }

    public boolean isRegisterMBeans() {
        return this.registerMBeans;
    }

    public void setRegisterMBeans(boolean registerMBeans) {
        this.registerMBeans = registerMBeans;
    }

    @Override
    public synchronized void reload() {
        if (this.context == null) {
            throw new IllegalStateException("GraniteConfig was not registered in ServletContext");
        }
        ServletGraniteConfig oldConfig = (ServletGraniteConfig)this.context.getAttribute(GRANITE_CONFIG_KEY);
        try {
            this.context.removeAttribute(GRANITE_CONFIG_KEY);
            ServletGraniteContext.createThreadInstance(null, null, this.context, (String)null, null);
            GraniteConfig config = ServletGraniteConfig.loadConfig(this.context);
            for (GraniteConfigReloadListener listener : this.reloadListeners) {
                try {
                    listener.onReload(this.context, config);
                }
                catch (Exception e) {
                    log.error(e, "Error while calling reload listener: %s", listener);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            GraniteContext.release();
            if (this.context.getAttribute(GRANITE_CONFIG_KEY) == null) {
                this.context.setAttribute(GRANITE_CONFIG_KEY, (Object)oldConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReloadListener(GraniteConfigReloadListener listener) {
        List<GraniteConfigReloadListener> list = this.reloadListeners;
        synchronized (list) {
            if (!this.reloadListeners.contains(listener)) {
                this.reloadListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeReloadListener(GraniteConfigReloadListener listener) {
        List<GraniteConfigReloadListener> list = this.reloadListeners;
        synchronized (list) {
            return this.reloadListeners.remove(listener);
        }
    }

    @Override
    public boolean getScan() {
        return this.config.getScan();
    }

    @Override
    public String getAmf3DeserializerClass() {
        return MBeanUtil.format(this.config.getAmf3DeserializerConstructor() != null ? this.config.getAmf3DeserializerConstructor().getDeclaringClass().getName() : null);
    }

    @Override
    public String getAmf3SerializerClass() {
        return MBeanUtil.format(this.config.getAmf3SerializerConstructor() != null ? this.config.getAmf3SerializerConstructor().getDeclaringClass().getName() : null);
    }

    @Override
    public String getAmf3MessageInterceptorClass() {
        return MBeanUtil.format(this.config.getAmf3MessageInterceptor() != null ? this.config.getAmf3MessageInterceptor().getClass().getName() : null);
    }

    @Override
    public String getClassGetterClass() {
        return MBeanUtil.format(this.config.getClassGetter() != null ? this.config.getClassGetter().getClass().getName() : null);
    }

    @Override
    public String getMessageSelectorClass() {
        return MBeanUtil.format(this.config.getMessageSelectorConstructor() != null ? this.config.getMessageSelectorConstructor().getDeclaringClass().getName() : null);
    }

    @Override
    public String getMethodMatcherClass() {
        return MBeanUtil.format(this.config.getMethodMatcher() != null ? this.config.getMethodMatcher().getClass().getName() : null);
    }

    @Override
    public String getSecurityServiceClass() {
        return MBeanUtil.format(this.config.getSecurityService() != null ? this.config.getSecurityService().getClass().getName() : null);
    }

    @Override
    public String getServiceInvocationListenerClass() {
        return MBeanUtil.format(this.config.getInvocationListener() != null ? this.config.getInvocationListener().getClass().getName() : null);
    }

    @Override
    public String showStandardConfig() throws IOException {
        String s = StreamUtil.getResourceAsString("org/granite/config/granite-config.xml", this.getClass().getClassLoader());
        return MBeanUtil.format(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String showCustomConfig() throws IOException {
        String path = this.getCustomConfigPath();
        InputStream is = this.context.getResourceAsStream(path);
        try {
            String s = StreamUtil.getStreamAsString(is);
            String string = MBeanUtil.format(s);
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public String showConverters() {
        Converter[] cs = this.config.getConverters().getConverters();
        String[] names = new String[cs.length];
        for (int i = 0; i < cs.length; ++i) {
            names[i] = cs[i].getClass().getName();
        }
        return MBeanUtil.format(names);
    }

    @Override
    public String showExceptionConverters() {
        String[] names = new String[this.config.getExceptionConverters().size()];
        for (int i = 0; i < this.config.getExceptionConverters().size(); ++i) {
            names[i] = this.config.getExceptionConverters().get(i).getClass().getName();
        }
        return MBeanUtil.format(names);
    }

    @Override
    public String showInstantiators() {
        String[] names = new String[this.config.getInstantiators().size()];
        int i = 0;
        for (Map.Entry<String, String> e : this.config.getInstantiators().entrySet()) {
            names[i++] = e.getKey() + "=" + e.getValue();
        }
        return MBeanUtil.format(names, true);
    }

    @Override
    public String showAs3DescriptorsByInstanceOf() {
        String[] names = new String[this.config.getAs3DescriptorsByInstanceOf().size()];
        int i = 0;
        for (Map.Entry<String, String> e : this.config.getAs3DescriptorsByInstanceOf().entrySet()) {
            names[i++] = e.getKey() + "=" + e.getValue();
        }
        return MBeanUtil.format(names, true);
    }

    @Override
    public String showAs3DescriptorsByType() {
        String[] names = new String[this.config.getAs3DescriptorsByType().size()];
        int i = 0;
        for (Map.Entry<String, Class<? extends ActionScriptClassDescriptor>> e : this.config.getAs3DescriptorsByType().entrySet()) {
            names[i++] = e.getKey() + "=" + e.getValue().getName();
        }
        return MBeanUtil.format(names, true);
    }

    @Override
    public String showDisabledTideComponentsByName() {
        String[] names = new String[this.config.getDisabledTideComponentsByName().size()];
        int i = 0;
        for (Map.Entry<String, Object[]> e : this.config.getDisabledTideComponentsByName().entrySet()) {
            names[i++] = e.getKey() + "=" + e.getValue()[0];
        }
        return MBeanUtil.format(names, true);
    }

    @Override
    public String showEnabledTideComponentsByName() {
        String[] names = new String[this.config.getEnabledTideComponentsByName().size()];
        int i = 0;
        for (Map.Entry<String, Object[]> e : this.config.getEnabledTideComponentsByName().entrySet()) {
            names[i++] = e.getKey() + "=" + e.getValue()[0];
        }
        return MBeanUtil.format(names, true);
    }

    @Override
    public String showExternalizersByAnnotatedWith() {
        String[] names = new String[this.config.getExternalizersByAnnotatedWith().size()];
        int i = 0;
        for (Map.Entry<String, String> e : this.config.getExternalizersByAnnotatedWith().entrySet()) {
            names[i++] = e.getKey() + "=" + e.getValue();
        }
        return MBeanUtil.format(names, true);
    }

    @Override
    public String showExternalizersByInstanceOf() {
        String[] names = new String[this.config.getExternalizersByInstanceOf().size()];
        int i = 0;
        for (Map.Entry<String, String> e : this.config.getExternalizersByInstanceOf().entrySet()) {
            names[i++] = e.getKey() + "=" + e.getValue();
        }
        return MBeanUtil.format(names, true);
    }

    @Override
    public String showExternalizersByType() {
        ArrayList<String> names = new ArrayList<String>(this.config.getExternalizersByType().size());
        for (Map.Entry<String, Externalizer> e : this.config.getExternalizersByType().entrySet()) {
            if (this.config.EXTERNALIZER_FACTORY.getNullInstance() == e.getValue()) continue;
            names.add(e.getKey() + "=" + e.getValue().getClass().getName());
        }
        return MBeanUtil.format(names.toArray(new String[names.size()]), true);
    }

    @Override
    public String showJavaDescriptorsByInstanceOf() {
        String[] names = new String[this.config.getJavaDescriptorsByInstanceOf().size()];
        int i = 0;
        for (Map.Entry<String, String> e : this.config.getJavaDescriptorsByInstanceOf().entrySet()) {
            names[i++] = e.getKey() + "=" + e.getValue();
        }
        return MBeanUtil.format(names, true);
    }

    @Override
    public String showJavaDescriptorsByType() {
        String[] names = new String[this.config.getJavaDescriptorsByType().size()];
        int i = 0;
        for (Map.Entry<String, Class<? extends JavaClassDescriptor>> e : this.config.getJavaDescriptorsByType().entrySet()) {
            names[i++] = e.getKey() + "=" + e.getValue().getName();
        }
        return MBeanUtil.format(names, true);
    }

    @Override
    public String showScannedExternalizers() {
        String[] names = new String[this.config.getScannedExternalizers().size()];
        for (int i = 0; i < this.config.getScannedExternalizers().size(); ++i) {
            names[i] = this.config.getScannedExternalizers().get(i).getClass().getName();
        }
        return MBeanUtil.format(names);
    }

    @Override
    public String showTideComponentMatchers() {
        String[] names = new String[this.config.getTideComponentMatchers().size()];
        for (int i = 0; i < this.config.getTideComponentMatchers().size(); ++i) {
            names[i] = this.config.getTideComponentMatchers().get(i).toString();
        }
        return MBeanUtil.format(names);
    }
}

