/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.websocket;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import javax.servlet.http.HttpSession;
import org.granite.context.GraniteContext;
import org.granite.context.SimpleGraniteContext;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.Channel;
import org.granite.gravity.ChannelFactory;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.MessageReceivingException;
import org.granite.logging.Logger;
import org.granite.messaging.jmf.JMFDeserializer;
import org.granite.messaging.jmf.JMFSerializer;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.util.ContentType;

public abstract class AbstractWebSocketChannel
extends AbstractChannel {
    private static final int DEFAULT_MAX_BINARY_MESSAGE_BUFFER_SIZE = 16384;
    private static final Logger log = Logger.getLogger(AbstractWebSocketChannel.class);
    private static final Logger logFine = Logger.getLogger(AbstractWebSocketChannel.class.getName() + "_fine");
    private HttpSession session;
    private ContentType contentType;
    private Object clientId;
    private byte[] connectAckMessage;
    private int maxBinaryMessageBufferSize = 16384;

    protected AbstractWebSocketChannel(GravityInternal gravity, String id, ChannelFactory<? extends Channel> factory, String clientType) {
        super(gravity, id, factory, clientType);
    }

    protected void setMaxBinaryMessageBufferSize(int maxBinaryMessageBufferSize) {
        if (maxBinaryMessageBufferSize < 512) {
            log.warn("Trying to set WebSocket maxBinaryMessageBufferSize too low: %d (ignored)", maxBinaryMessageBufferSize);
        } else {
            log.debug("Setting MaxBinaryMessageBufferSize to: %d", maxBinaryMessageBufferSize);
            this.maxBinaryMessageBufferSize = maxBinaryMessageBufferSize;
        }
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public void setConnectAckMessage(Message ackMessage) {
        try {
            this.clientId = ackMessage.getClientId();
            this.connectAckMessage = this.serialize(this.getGravity(), new Message[]{ackMessage});
        }
        catch (IOException e) {
            throw new RuntimeException("Could not serialize connect acknowledge", e);
        }
    }

    protected void connect() {
        log.debug("Channel %s websocket connect clientId %s %s", this.getId(), this.clientId, this.connectAckMessage == null ? "(no ack)" : "");
        if (this.connectAckMessage == null) {
            return;
        }
        try {
            this.sendBytes(this.connectAckMessage);
            this.connectAckMessage = null;
        }
        catch (IOException e) {
            log.error(e, "Channel %s could not send connect acknowledge", this.getId());
        }
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    protected GravityInternal initializeRequest() {
        if (this.session != null) {
            ServletGraniteContext.createThreadInstance(this.gravity.getGraniteConfig(), this.gravity.getServicesConfig(), this.session.getServletContext(), this.session, this.clientType);
        } else {
            SimpleGraniteContext.createThreadInstance(this.gravity.getGraniteConfig(), this.gravity.getServicesConfig(), this.sessionId, new HashMap<String, Object>(), this.clientType);
        }
        return this.gravity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message[] deserialize(GravityInternal gravity, byte[] data, int offset, int length) throws ClassNotFoundException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset, length);
        try {
            Message[] messages = null;
            if (ContentType.JMF_AMF.equals((Object)this.contentType)) {
                JMFDeserializer deserializer = new JMFDeserializer(is, gravity.getGraniteConfig().getSharedContext());
                messages = (Message[])deserializer.readObject();
            } else {
                ObjectInput amf3Deserializer = gravity.getGraniteConfig().newAMF3Deserializer(is);
                Object[] objects = (Object[])amf3Deserializer.readObject();
                messages = new Message[objects.length];
                System.arraycopy(objects, 0, messages, 0, objects.length);
            }
            Message[] messageArray = messages;
            return messageArray;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] serialize(GravityInternal gravity, Message[] messages) throws IOException {
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream(200 * messages.length);
            if (ContentType.JMF_AMF.equals((Object)this.contentType)) {
                JMFSerializer serializer = new JMFSerializer(os, gravity.getGraniteConfig().getSharedContext());
                serializer.writeObject(messages);
            } else {
                ObjectOutput amf3Serializer = gravity.getGraniteConfig().newAMF3Serializer(os);
                amf3Serializer.writeObject(messages);
                amf3Serializer.flush();
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    protected static void cleanupRequest() {
        GraniteContext.release();
    }

    protected abstract boolean isConnected();

    protected abstract void sendBytes(byte[] var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveBytes(byte[] data, int offset, int length) {
        log.debug("Channel %s websocket receive %d bytes", this.getId(), data.length);
        try {
            this.initializeRequest();
            Message[] messages = this.deserialize(this.getGravity(), data, offset, length);
            logFine.debug(">> [AMF3 REQUESTS] %s", new Object[]{messages});
            Message[] responses = null;
            boolean accessed = false;
            int responseIndex = 0;
            for (int i = 0; i < messages.length; ++i) {
                Message message = messages[i];
                Message response = this.getGravity().handleMessage(this.getFactory(), message);
                String string = (String)message.getClientId();
                log.debug("Channel %s received message %s for clientId %s", this.getId(), message.getMessageId(), string);
                if (!accessed) {
                    accessed = this.getGravity().access(string);
                }
                if (response == null) continue;
                responses = responses == null ? new Message[1] : Arrays.copyOf(responses, responses.length + 1);
                responses[responseIndex++] = response;
            }
            if (this.isConnected()) {
                logFine.debug("<< [AMF3 RESPONSES] %s", new Object[]{responses});
                for (void var11_19 : responses) {
                    if (!(var11_19 instanceof AsyncMessage)) continue;
                    this.receive((AsyncMessage)var11_19);
                }
            }
        }
        catch (MessageReceivingException e) {
            log.error(e, "Could not handle incoming message data", new Object[0]);
        }
        catch (ClassNotFoundException e) {
            log.error(e, "Could not handle incoming message data", new Object[0]);
        }
        catch (IOException e) {
            log.error(e, "Could not handle incoming message data", new Object[0]);
        }
        finally {
            AbstractWebSocketChannel.cleanupRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean runReceived(AsyncHttpContext asyncHttpContext) {
        LinkedList messages = null;
        ByteArrayOutputStream os = null;
        try {
            int index;
            this.receivedQueueLock.lock();
            try {
                if (this.receivedQueue.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                messages = this.receivedQueue;
                this.receivedQueue = new LinkedList();
            }
            finally {
                this.receivedQueueLock.unlock();
            }
            if (!this.isConnected()) {
                log.debug("Channel %s is not connected", this.getId());
                boolean bl = false;
                return bl;
            }
            GravityInternal gravity = this.getGravity();
            SimpleGraniteContext.createThreadInstance(gravity.getGraniteConfig(), gravity.getServicesConfig(), this.sessionId, new HashMap<String, Object>(), this.clientType);
            Message[] messagesArray = messages.toArray(new AsyncMessage[messages.size()]);
            logFine.debug("<< [MESSAGES for channel=%s] %s", this, messagesArray);
            byte[] msg = this.serialize(gravity, messagesArray);
            if (msg.length <= this.maxBinaryMessageBufferSize) {
                log.debug("Channel %s send binary message: %d msgs (%d bytes)", this.getId(), messagesArray.length, msg.length);
                this.sendBytes(msg);
            } else {
                index = 1;
                for (Message message : messagesArray) {
                    msg = this.serialize(gravity, new AsyncMessage[]{message});
                    log.debug("Channel %s send chunked binary message: %d/%d msgs (%d bytes)", this.getId(), index++, messagesArray.length, msg.length);
                    this.sendBytes(msg);
                }
            }
            index = 1;
            return index != 0;
        }
        catch (IOException e) {
            log.warn(e, "Could not send messages to channel: %s (retrying later)", this);
            GravityConfig gravityConfig = this.getGravity().getGravityConfig();
            if (gravityConfig.isRetryOnError()) {
                this.receivedQueueLock.lock();
                try {
                    if (this.receivedQueue.size() + messages.size() > gravityConfig.getMaxMessagesQueuedPerChannel()) {
                        log.warn("Channel %s has reached its maximum queue capacity %s (throwing %s messages)", this, gravityConfig.getMaxMessagesQueuedPerChannel(), messages.size());
                    } else {
                        this.receivedQueue.addAll(0, messages);
                    }
                }
                finally {
                    this.receivedQueueLock.unlock();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {}
            }
            try {
                GraniteContext.release();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(boolean timeout) {
        try {
            super.destroy(timeout);
        }
        finally {
            this.close();
        }
    }

    @Override
    protected boolean hasAsyncHttpContext() {
        return true;
    }

    @Override
    protected void releaseAsyncHttpContext(AsyncHttpContext context) {
    }

    @Override
    protected AsyncHttpContext acquireAsyncHttpContext() {
        return null;
    }
}

