/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io;

import flex.messaging.io.ArrayCollection;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;
import org.granite.config.ConvertersConfig;
import org.granite.config.ExternalizersConfig;
import org.granite.config.flex.ChannelConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.AMF3Constants;
import org.granite.messaging.amf.io.AMF3SerializationException;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.ClassGetter;
import org.granite.messaging.amf.io.util.DefaultJavaClassDescriptor;
import org.granite.messaging.amf.io.util.IndexedJavaClassDescriptor;
import org.granite.messaging.amf.io.util.JavaClassDescriptor;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;
import org.granite.messaging.amf.types.AMFDictionaryValue;
import org.granite.messaging.amf.types.AMFSpecialValue;
import org.granite.messaging.amf.types.AMFVectorIntValue;
import org.granite.messaging.amf.types.AMFVectorNumberValue;
import org.granite.messaging.amf.types.AMFVectorObjectValue;
import org.granite.messaging.amf.types.AMFVectorUintValue;
import org.granite.util.ObjectIndexedCache;
import org.granite.util.StringIndexedCache;
import org.granite.util.TypeUtil;
import org.granite.util.XMLUtil;
import org.granite.util.XMLUtilFactory;
import org.w3c.dom.Document;

public class AMF3Serializer
implements ObjectOutput,
AMF3Constants {
    protected static final AMF3Writer AMF3_STRING_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3String(o.toString());
        }
    };
    protected static final AMF3Writer AMF3_BOOLEAN_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3Boolean((Boolean)o);
        }
    };
    protected static final AMF3Writer AMF3_INTEGER_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3Integer(((Number)o).intValue());
        }
    };
    protected static final AMF3Writer AMF3_NUMBER_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3Number(((Number)o).doubleValue());
        }
    };
    protected static final AMF3Writer AMF3_DATE_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3Date((Date)o);
        }
    };
    protected static final AMF3Writer AMF3_CALENDAR_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3Date(((Calendar)o).getTime());
        }
    };
    protected static final AMF3Writer AMF3_DOCUMENT_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3Xml((Document)o);
        }
    };
    protected static final AMF3Writer AMF3_COLLECTION_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3Collection((Collection)o);
        }
    };
    protected static final AMF3Writer AMF3_BOOLEAN_ARRAY_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3BooleanArray((boolean[])o);
        }
    };
    protected static final AMF3Writer AMF3_CHAR_ARRAY_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3CharArray((char[])o);
        }
    };
    protected static final AMF3Writer AMF3_CHAR_OBJECT_ARRAY_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3CharObjectArray((Character[])o);
        }
    };
    protected static final AMF3Writer AMF3_BYTE_ARRAY_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3ByteArray((byte[])o);
        }
    };
    protected static final AMF3Writer AMF3_BYTE_OBJECT_ARRAY_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3ByteObjectArray((Byte[])o);
        }
    };
    protected static final AMF3Writer AMF3_SHORT_ARRAY_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3ShortArray((short[])o);
        }
    };
    protected static final AMF3Writer AMF3_INT_ARRAY_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3IntArray((int[])o);
        }
    };
    protected static final AMF3Writer AMF3_LONG_ARRAY_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3LongArray((long[])o);
        }
    };
    protected static final AMF3Writer AMF3_FLOAT_ARRAY_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3FloatArray((float[])o);
        }
    };
    protected static final AMF3Writer AMF3_DOUBLE_ARRAY_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3DoubleArray((double[])o);
        }
    };
    protected static final AMF3Writer AMF3_OBJECT_ARRAY_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3ObjectArray(o);
        }
    };
    protected static final AMF3Writer AMF3_SPECIAL_VALUE_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3SpecialValue((AMFSpecialValue)o);
        }
    };
    protected static final AMF3Writer AMF3_OBJECT_WRITER = new AMF3Writer(){

        @Override
        public void write(AMF3Serializer serializer, Object o) throws IOException {
            serializer.writeAMF3Object(o);
        }
    };
    protected final OutputStream out;
    protected final byte[] buffer;
    protected int position;
    protected final StringIndexedCache storedStrings;
    protected final ObjectIndexedCache storedObjects;
    protected final Map<Class<?>, IndexedJavaClassDescriptor> storedClassDescriptors;
    protected final Map<Class<?>, AMF3Writer> writersCache;
    protected final Converters converters;
    protected final ClassGetter classGetter;
    protected final XMLUtil xmlUtil;
    protected final ExternalizersConfig externalizersConfig;
    protected final boolean externalizeLong;
    protected final boolean externalizeBigInteger;
    protected final boolean externalizeBigDecimal;
    protected final boolean legacyXmlSerialization;
    protected final boolean legacyCollectionSerialization;

    public AMF3Serializer(OutputStream out) {
        this(out, 1024);
    }

    public AMF3Serializer(OutputStream out, int capacity) {
        this.out = out;
        this.buffer = new byte[capacity];
        this.position = 0;
        this.storedStrings = new StringIndexedCache();
        this.storedObjects = new ObjectIndexedCache();
        this.storedClassDescriptors = new IdentityHashMap();
        this.writersCache = new IdentityHashMap(64);
        GraniteContext context = GraniteContext.getCurrentInstance();
        ConvertersConfig convertersConfig = (ConvertersConfig)context.getGraniteConfig();
        this.converters = convertersConfig.getConverters();
        this.classGetter = convertersConfig.getClassGetter();
        this.xmlUtil = XMLUtilFactory.getXMLUtil();
        this.externalizersConfig = (ExternalizersConfig)context.getGraniteConfig();
        this.externalizeLong = this.externalizersConfig.getExternalizer(Long.class.getName()) != null;
        this.externalizeBigInteger = this.externalizersConfig.getExternalizer(BigInteger.class.getName()) != null;
        this.externalizeBigDecimal = this.externalizersConfig.getExternalizer(BigDecimal.class.getName()) != null;
        String channelId = context.getAMFContext().getChannelId();
        ChannelConfig channelConfig = (ChannelConfig)context.getServicesConfig();
        this.legacyXmlSerialization = AMF3Serializer.getChannelProperty(channelId, channelConfig, "legacyXmlSerialization");
        this.legacyCollectionSerialization = AMF3Serializer.getChannelProperty(channelId, channelConfig, "legacyCollectionSerialization");
    }

    protected static boolean getChannelProperty(String channelId, ChannelConfig channelConfig, String name) {
        if (channelId != null && channelConfig != null) {
            return channelConfig.getChannelProperty(channelId, name);
        }
        return false;
    }

    public void reset() {
        this.storedStrings.clear();
        this.storedObjects.clear();
        this.storedClassDescriptors.clear();
    }

    @Override
    public void writeObject(Object o) throws IOException {
        if (o != null) {
            o = this.converters.revert(o);
        }
        if (o == null) {
            this.writeAMF3Null();
        } else {
            Class<?> cls = o.getClass();
            if (cls == String.class) {
                this.writeAMF3String((String)o);
                return;
            }
            if (cls == Integer.class) {
                this.writeAMF3Integer((Integer)o);
                return;
            }
            if (cls == Boolean.class) {
                this.writeAMF3Boolean((Boolean)o);
                return;
            }
            AMF3Writer writer = this.writersCache.get(cls);
            if (writer == null) {
                writer = this.getWriter(cls);
                this.writersCache.put(cls, writer);
            }
            writer.write(this, o);
        }
    }

    protected void writeAMF3Null() throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 1;
    }

    protected void writeAMF3Boolean(boolean value) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = value ? 3 : 2;
    }

    protected void writeAMF3Integer(int i) throws IOException {
        if (i < -268435456 || i > 0xFFFFFFF) {
            this.writeAMF3Number(i);
        } else {
            this.ensureCapacity(1);
            this.buffer[this.position++] = 4;
            this.writeAMF3UnsignedIntegerData(i & 0x1FFFFFFF);
        }
    }

    protected void writeAMF3UnsignedIntegerData(int i) throws IOException {
        if (i < 0) {
            throw new AMF3SerializationException("Negative unsigned int: " + i);
        }
        this.ensureCapacity(4);
        byte[] buffer = this.buffer;
        int position = this.position;
        if (i < 16384) {
            if (i < 128) {
                buffer[position++] = (byte)i;
            } else {
                buffer[position++] = (byte)(i >>> 7 | 0x80);
                buffer[position++] = (byte)(i & 0x7F);
            }
        } else if (i < 0x40000000) {
            if (i < 0x200000) {
                buffer[position++] = (byte)(i >>> 14 | 0x80);
                buffer[position++] = (byte)(i >>> 7 | 0x80);
                buffer[position++] = (byte)(i & 0x7F);
            } else {
                buffer[position++] = (byte)(i >>> 22 | 0x80);
                buffer[position++] = (byte)(i >>> 15 | 0x80);
                buffer[position++] = (byte)(i >>> 8 | 0x80);
                buffer[position++] = (byte)i;
            }
        } else {
            throw new AMF3SerializationException("Unsigned int out of range: " + i);
        }
        this.position = position;
    }

    protected void writeAMF3Number(double d) throws IOException {
        this.ensureCapacity(9);
        this.buffer[this.position++] = 5;
        this.position = AMF3Serializer.writeLongData(this.buffer, this.position, Double.doubleToLongBits(d));
    }

    protected void writeAMF3String(String s) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 6;
        this.writeAMF3StringData(s);
    }

    protected void writeAMF3StringData(String s) throws IOException {
        int length = s.length();
        if (length == 0) {
            this.ensureCapacity(1);
            this.buffer[this.position++] = 1;
            return;
        }
        int index = this.storedStrings.putIfAbsent(s);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            int count = AMF3Serializer.utfByteCount(s);
            this.writeAMF3UnsignedIntegerData(count << 1 | 1);
            byte[] buffer = this.buffer;
            int bufferLength = buffer.length;
            int position = this.position;
            if (count == length) {
                if (length <= bufferLength - position) {
                    for (int i = 0; i < length; ++i) {
                        buffer[position++] = (byte)s.charAt(i);
                    }
                    this.position = position;
                } else {
                    int i = 0;
                    while (position < bufferLength) {
                        buffer[position++] = (byte)s.charAt(i++);
                    }
                    this.position = position;
                    do {
                        this.flushBuffer();
                        position = 0;
                        int max = Math.min(bufferLength, length - i);
                        while (position < max) {
                            buffer[position++] = (byte)s.charAt(i++);
                        }
                        this.position = position;
                    } while (i < length);
                }
            } else if (count <= bufferLength - position) {
                for (int i = 0; i < length; ++i) {
                    char c = s.charAt(i);
                    if (c <= '\u007f') {
                        buffer[position++] = (byte)c;
                        continue;
                    }
                    if (c > '\u07ff') {
                        buffer[position++] = (byte)(0xE0 | c >>> 12);
                        buffer[position++] = (byte)(0x80 | c >>> 6 & 0x3F);
                        buffer[position++] = (byte)(0x80 | c & 0x3F);
                        continue;
                    }
                    buffer[position++] = (byte)(0xC0 | c >>> 6 & 0x1F);
                    buffer[position++] = (byte)(0x80 | c & 0x3F);
                }
                this.position = position;
            } else {
                int bufferLengthMinus3 = buffer.length - 3;
                int i = 0;
                int total = 0;
                do {
                    this.flushBuffer();
                    position = 0;
                    int max = Math.min(count - total, bufferLengthMinus3);
                    while (position < max) {
                        char c;
                        if ((c = s.charAt(i++)) <= '\u007f') {
                            buffer[position++] = (byte)c;
                            continue;
                        }
                        if (c > '\u07ff') {
                            buffer[position++] = (byte)(0xE0 | c >>> 12);
                            buffer[position++] = (byte)(0x80 | c >>> 6 & 0x3F);
                            buffer[position++] = (byte)(0x80 | c & 0x3F);
                            continue;
                        }
                        buffer[position++] = (byte)(0xC0 | c >>> 6 & 0x1F);
                        buffer[position++] = (byte)(0x80 | c & 0x3F);
                    }
                    this.position = position;
                } while ((total += position) < count);
            }
        }
    }

    protected void writeAMF3Xml(Document doc) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = this.legacyXmlSerialization ? 7 : 11;
        int index = this.storedObjects.putIfAbsent(doc);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            byte[] bytes = this.xmlUtil.toString(doc).getBytes("UTF-8");
            this.writeAMF3UnsignedIntegerData(bytes.length << 1 | 1);
            this.flushBuffer();
            this.out.write(bytes, 0, bytes.length);
        }
    }

    protected void writeAMF3Date(Date date) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 8;
        int index = this.storedObjects.putIfAbsent(date);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            this.writeAMF3UnsignedIntegerData(1);
            this.ensureCapacity(8);
            this.position = AMF3Serializer.writeLongData(this.buffer, this.position, Double.doubleToRawLongBits(date.getTime()));
        }
    }

    protected void writeAMF3BooleanArray(boolean[] array) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 9;
        int index = this.storedObjects.putIfAbsent(array);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            this.writeAMF3UnsignedIntegerData(array.length << 1 | 1);
            this.ensureCapacity(1);
            this.buffer[this.position++] = 1;
            for (boolean i : array) {
                this.writeAMF3Boolean(i);
            }
        }
    }

    protected void writeAMF3CharArray(char[] array) throws IOException {
        this.writeAMF3String(new String(array));
    }

    protected void writeAMF3CharObjectArray(Character[] array) throws IOException {
        int length = array.length;
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            Character c = array[i];
            chars[i] = c == null ? (char)'\u0000' : c.charValue();
        }
        this.writeAMF3String(new String(chars));
    }

    protected void writeAMF3ByteArray(byte[] bytes) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 12;
        int index = this.storedObjects.putIfAbsent(bytes);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            this.writeAMF3UnsignedIntegerData(bytes.length << 1 | 1);
            this.flushBuffer();
            this.out.write(bytes, 0, bytes.length);
        }
    }

    protected void writeAMF3ByteObjectArray(Byte[] array) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 12;
        int index = this.storedObjects.putIfAbsent(array);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            int length = array.length;
            this.writeAMF3UnsignedIntegerData(length << 1 | 1);
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                Byte b = array[i];
                bytes[i] = b == null ? (byte)0 : b;
            }
            this.flushBuffer();
            this.out.write(bytes, 0, length);
        }
    }

    protected void writeAMF3ShortArray(short[] array) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 9;
        int index = this.storedObjects.putIfAbsent(array);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            this.writeAMF3UnsignedIntegerData(array.length << 1 | 1);
            this.ensureCapacity(1);
            this.buffer[this.position++] = 1;
            for (short i : array) {
                this.writeAMF3Integer(i);
            }
        }
    }

    protected void writeAMF3IntArray(int[] array) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 9;
        int index = this.storedObjects.putIfAbsent(array);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            this.writeAMF3UnsignedIntegerData(array.length << 1 | 1);
            this.ensureCapacity(1);
            this.buffer[this.position++] = 1;
            for (int i : array) {
                this.writeAMF3Integer(i);
            }
        }
    }

    protected void writeAMF3LongArray(long[] array) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 9;
        int index = this.storedObjects.putIfAbsent(array);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            this.writeAMF3UnsignedIntegerData(array.length << 1 | 1);
            this.ensureCapacity(1);
            this.buffer[this.position++] = 1;
            for (long i : array) {
                this.writeAMF3Number(i);
            }
        }
    }

    protected void writeAMF3FloatArray(float[] array) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 9;
        int index = this.storedObjects.putIfAbsent(array);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            this.writeAMF3UnsignedIntegerData(array.length << 1 | 1);
            this.ensureCapacity(1);
            this.buffer[this.position++] = 1;
            for (float i : array) {
                this.writeAMF3Number(i);
            }
        }
    }

    protected void writeAMF3DoubleArray(double[] array) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 9;
        int index = this.storedObjects.putIfAbsent(array);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            this.writeAMF3UnsignedIntegerData(array.length << 1 | 1);
            this.ensureCapacity(1);
            this.buffer[this.position++] = 1;
            for (double i : array) {
                this.writeAMF3Number(i);
            }
        }
    }

    protected void writeAMF3ObjectArray(Object array) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 9;
        int index = this.storedObjects.putIfAbsent(array);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            int length = Array.getLength(array);
            this.writeAMF3UnsignedIntegerData(length << 1 | 1);
            this.ensureCapacity(1);
            this.buffer[this.position++] = 1;
            for (int i = 0; i < length; ++i) {
                this.writeObject(Array.get(array, i));
            }
        }
    }

    protected void writeAMF3Collection(Collection<?> c) throws IOException {
        if (this.legacyCollectionSerialization) {
            this.writeAMF3ObjectArray(c.toArray());
        } else {
            this.ensureCapacity(1);
            this.buffer[this.position++] = 10;
            int index = this.storedObjects.putIfAbsent(c);
            if (index >= 0) {
                this.writeAMF3UnsignedIntegerData(index << 1);
            } else {
                this.writeAndGetAMF3Descriptor(ArrayCollection.class);
                this.ensureCapacity(1);
                this.buffer[this.position++] = 9;
                this.storedObjects.putIfAbsent(new Object());
                this.writeAMF3UnsignedIntegerData(c.size() << 1 | 1);
                this.ensureCapacity(1);
                this.buffer[this.position++] = 1;
                for (Object o : c) {
                    this.writeObject(o);
                }
            }
        }
    }

    protected void writeAMF3Object(Object o) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 10;
        int index = this.storedObjects.putIfAbsent(o);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            Class<?> oClass = this.classGetter.getClass(o);
            JavaClassDescriptor desc = this.writeAndGetAMF3Descriptor(oClass);
            if (desc.isExternalizable()) {
                Externalizer externalizer = desc.getExternalizer();
                if (externalizer != null) {
                    try {
                        externalizer.writeExternal(o, this);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not externalize object: " + o, e);
                    }
                } else {
                    ((Externalizable)o).writeExternal(this);
                }
            } else {
                int count = desc.getPropertiesCount();
                for (int i = 0; i < count; ++i) {
                    Property property = desc.getProperty(i);
                    this.writeObject(property.getValue(o));
                }
                if (desc.isDynamic()) {
                    Map oMap = (Map)o;
                    for (Map.Entry entry : oMap.entrySet()) {
                        String propertyName;
                        Object key = entry.getKey();
                        if (key == null || (propertyName = key.toString()).length() <= 0) continue;
                        this.writeAMF3StringData(propertyName);
                        this.writeObject(entry.getValue());
                    }
                    this.ensureCapacity(1);
                    this.buffer[this.position++] = 1;
                }
            }
        }
    }

    protected void writeAMF3SpecialValue(AMFSpecialValue<?> value) throws IOException {
        switch (value.type) {
            case 17: {
                this.writeAMF3Dictionary((AMFDictionaryValue)value);
                break;
            }
            case 13: {
                this.writeAMF3VectorInt((AMFVectorIntValue)value);
                break;
            }
            case 15: {
                this.writeAMF3VectorNumber((AMFVectorNumberValue)value);
                break;
            }
            case 14: {
                this.writeAMF3VectorUint((AMFVectorUintValue)value);
                break;
            }
            case 16: {
                this.writeAMF3VectorObject((AMFVectorObjectValue)value);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported AMF special value: " + value);
            }
        }
    }

    protected void writeAMF3VectorObject(AMFVectorObjectValue value) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 16;
        Object o = value.value;
        int index = this.storedObjects.putIfAbsent(o);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            int length = this.getArrayOrCollectionLength(o);
            this.writeAMF3UnsignedIntegerData(length << 1 | 1);
            this.ensureCapacity(1);
            this.buffer[this.position++] = (byte)(value.fixed ? 1 : 0);
            this.writeAMF3StringData(value.type);
            if (o.getClass().isArray()) {
                for (int i = 0; i < length; ++i) {
                    this.writeObject(Array.get(o, i));
                }
            } else {
                for (Object item : (Collection)o) {
                    this.writeObject(item);
                }
            }
        }
    }

    protected void writeAMF3VectorInt(AMFVectorIntValue value) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 13;
        Object o = value.value;
        int index = this.storedObjects.putIfAbsent(o);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            int length = this.getArrayOrCollectionLength(o);
            this.writeAMF3UnsignedIntegerData(length << 1 | 1);
            this.ensureCapacity(1);
            this.buffer[this.position++] = (byte)(value.fixed ? 1 : 0);
            if (o.getClass().isArray()) {
                for (int i = 0; i < length; ++i) {
                    this.ensureCapacity(4);
                    this.position = AMF3Serializer.writeIntData(this.buffer, this.position, ((Number)Array.get(o, i)).intValue());
                }
            } else {
                for (Object item : (Collection)o) {
                    this.ensureCapacity(4);
                    this.position = AMF3Serializer.writeIntData(this.buffer, this.position, ((Number)item).intValue());
                }
            }
        }
    }

    protected void writeAMF3VectorNumber(AMFVectorNumberValue value) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 15;
        Object o = value.value;
        int index = this.storedObjects.putIfAbsent(o);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            int length = this.getArrayOrCollectionLength(o);
            this.writeAMF3UnsignedIntegerData(length << 1 | 1);
            this.ensureCapacity(1);
            this.buffer[this.position++] = (byte)(value.fixed ? 1 : 0);
            if (o.getClass().isArray()) {
                for (int i = 0; i < length; ++i) {
                    this.ensureCapacity(8);
                    this.position = AMF3Serializer.writeLongData(this.buffer, this.position, Double.doubleToLongBits(((Number)Array.get(o, i)).doubleValue()));
                }
            } else {
                for (Object item : (Collection)o) {
                    this.ensureCapacity(8);
                    this.position = AMF3Serializer.writeLongData(this.buffer, this.position, Double.doubleToLongBits(((Number)item).doubleValue()));
                }
            }
        }
    }

    protected void writeAMF3VectorUint(AMFVectorUintValue value) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 14;
        Object o = value.value;
        int index = this.storedObjects.putIfAbsent(o);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            int length = this.getArrayOrCollectionLength(o);
            this.writeAMF3UnsignedIntegerData(length << 1 | 1);
            this.ensureCapacity(1);
            this.buffer[this.position++] = (byte)(value.fixed ? 1 : 0);
            if (o.getClass().isArray()) {
                for (int i = 0; i < length; ++i) {
                    this.ensureCapacity(4);
                    this.position = AMF3Serializer.writeIntData(this.buffer, this.position, ((Number)Array.get(o, i)).intValue());
                }
            } else {
                for (Object item : (Collection)o) {
                    this.ensureCapacity(4);
                    this.position = AMF3Serializer.writeIntData(this.buffer, this.position, ((Number)item).intValue());
                }
            }
        }
    }

    protected void writeAMF3Dictionary(AMFDictionaryValue value) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.position++] = 17;
        Map o = (Map)value.value;
        int index = this.storedObjects.putIfAbsent(o);
        if (index >= 0) {
            this.writeAMF3UnsignedIntegerData(index << 1);
        } else {
            int length = o.size();
            this.writeAMF3UnsignedIntegerData(length << 1 | 1);
            this.ensureCapacity(1);
            this.buffer[this.position++] = (byte)(value.weakKeys ? 1 : 0);
            for (Map.Entry entry : o.entrySet()) {
                this.writeObject(entry.getKey());
                this.writeObject(entry.getValue());
            }
        }
    }

    protected int getArrayOrCollectionLength(Object o) {
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        return ((Collection)o).size();
    }

    protected AMF3Writer getWriter(Class<?> cls) {
        if (cls.isPrimitive()) {
            throw new RuntimeException("Illegal primitive class: " + cls);
        }
        if (Externalizable.class.isAssignableFrom(cls)) {
            return AMF3_OBJECT_WRITER;
        }
        if (cls == String.class || cls == Character.class) {
            return AMF3_STRING_WRITER;
        }
        if (Number.class.isAssignableFrom(cls)) {
            if (cls == Integer.class || cls == Short.class || cls == Byte.class) {
                return AMF3_INTEGER_WRITER;
            }
            if (this.externalizeLong && cls == Long.class) {
                return AMF3_OBJECT_WRITER;
            }
            if (this.externalizeBigInteger && BigInteger.class.isAssignableFrom(cls)) {
                return AMF3_OBJECT_WRITER;
            }
            if (this.externalizeBigDecimal && BigDecimal.class.isAssignableFrom(cls)) {
                return AMF3_OBJECT_WRITER;
            }
            return AMF3_NUMBER_WRITER;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            return AMF3_COLLECTION_WRITER;
        }
        if (cls.isArray()) {
            Class<?> componentType = cls.getComponentType();
            if (componentType == Boolean.TYPE) {
                return AMF3_BOOLEAN_ARRAY_WRITER;
            }
            if (componentType == Character.TYPE) {
                return AMF3_CHAR_ARRAY_WRITER;
            }
            if (componentType == Character.class) {
                return AMF3_CHAR_OBJECT_ARRAY_WRITER;
            }
            if (componentType == Byte.TYPE) {
                return AMF3_BYTE_ARRAY_WRITER;
            }
            if (componentType == Byte.class) {
                return AMF3_BYTE_OBJECT_ARRAY_WRITER;
            }
            if (componentType == Short.TYPE) {
                return AMF3_SHORT_ARRAY_WRITER;
            }
            if (componentType == Integer.TYPE) {
                return AMF3_INT_ARRAY_WRITER;
            }
            if (componentType == Long.TYPE) {
                return AMF3_LONG_ARRAY_WRITER;
            }
            if (componentType == Float.TYPE) {
                return AMF3_FLOAT_ARRAY_WRITER;
            }
            if (componentType == Double.TYPE) {
                return AMF3_DOUBLE_ARRAY_WRITER;
            }
            return AMF3_OBJECT_ARRAY_WRITER;
        }
        if (cls == Boolean.class) {
            return AMF3_BOOLEAN_WRITER;
        }
        if (Date.class.isAssignableFrom(cls)) {
            return AMF3_DATE_WRITER;
        }
        if (Calendar.class.isAssignableFrom(cls)) {
            return AMF3_CALENDAR_WRITER;
        }
        if (Document.class.isAssignableFrom(cls)) {
            return AMF3_DOCUMENT_WRITER;
        }
        if (AMFSpecialValue.class.isAssignableFrom(cls)) {
            return AMF3_SPECIAL_VALUE_WRITER;
        }
        return AMF3_OBJECT_WRITER;
    }

    protected JavaClassDescriptor writeAndGetAMF3Descriptor(Class<?> cls) throws IOException {
        JavaClassDescriptor desc = null;
        IndexedJavaClassDescriptor iDesc = this.storedClassDescriptors.get(cls);
        if (iDesc != null) {
            desc = iDesc.getDescriptor();
            this.writeAMF3UnsignedIntegerData(iDesc.getIndex() << 2 | 1);
        } else {
            iDesc = this.addToStoredClassDescriptors(cls);
            desc = iDesc.getDescriptor();
            int count = desc.getPropertiesCount();
            this.writeAMF3UnsignedIntegerData(count << 4 | desc.getEncoding() << 2 | 3);
            this.writeAMF3StringData(desc.getName());
            for (int i = 0; i < count; ++i) {
                this.writeAMF3StringData(desc.getPropertyName(i));
            }
        }
        return desc;
    }

    protected IndexedJavaClassDescriptor addToStoredClassDescriptors(Class<?> clazz) {
        JavaClassDescriptor desc = (JavaClassDescriptor)this.externalizersConfig.getJavaDescriptorsCache().get(clazz.getName());
        if (desc == null) {
            Class<? extends JavaClassDescriptor> descriptorType = this.externalizersConfig.getJavaDescriptor(clazz.getName());
            if (descriptorType != null) {
                try {
                    desc = TypeUtil.newInstance(descriptorType, new Class[]{Class.class}, new Object[]{clazz});
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not instantiate Java descriptor: " + descriptorType);
                }
            } else {
                desc = new DefaultJavaClassDescriptor(clazz);
            }
            this.externalizersConfig.getJavaDescriptorsCache().putIfAbsent(clazz.getName(), desc);
        }
        IndexedJavaClassDescriptor iDesc = new IndexedJavaClassDescriptor(this.storedClassDescriptors.size(), desc);
        this.storedClassDescriptors.put(clazz, iDesc);
        return iDesc;
    }

    protected void ensureCapacity(int capacity) throws IOException {
        if (this.buffer.length - this.position < capacity) {
            this.flushBuffer();
        }
    }

    protected void flushBuffer() throws IOException {
        if (this.position > 0) {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    protected static int utfByteCount(String s) {
        int length;
        int count = length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c <= '\u007f') continue;
            if (c > '\u07ff') {
                count += 2;
                continue;
            }
            ++count;
        }
        return count;
    }

    protected static int writeIntData(byte[] buffer, int position, int i) {
        buffer[position++] = (byte)(i >>> 24);
        buffer[position++] = (byte)(i >>> 16);
        buffer[position++] = (byte)(i >>> 8);
        buffer[position++] = (byte)i;
        return position;
    }

    protected static int writeLongData(byte[] buffer, int position, long l) {
        buffer[position++] = (byte)(l >>> 56);
        buffer[position++] = (byte)(l >>> 48);
        buffer[position++] = (byte)(l >>> 40);
        buffer[position++] = (byte)(l >>> 32);
        buffer[position++] = (byte)(l >>> 24);
        buffer[position++] = (byte)(l >>> 16);
        buffer[position++] = (byte)(l >>> 8);
        buffer[position++] = (byte)l;
        return position;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.flushBuffer();
        this.out.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.flushBuffer();
        this.out.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.flushBuffer();
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.flushBuffer();
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.flushBuffer();
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.flushBuffer();
        byte[] writeBuffer = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        this.out.write(writeBuffer, 0, 8);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.flushBuffer();
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.flushBuffer();
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.flushBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.out.write((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.flushBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.out.write(v >>> 8 & 0xFF);
            this.out.write(v >>> 0 & 0xFF);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        char c;
        this.flushBuffer();
        int strlen = s.length();
        int utflen = 0;
        int count = 0;
        for (int i = 0; i < strlen; ++i) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i = 0;
        for (i = 0; i < strlen && (c = s.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        this.out.write(bytearr, 0, utflen + 2);
    }

    @Override
    public void write(int b) throws IOException {
        this.flushBuffer();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.flushBuffer();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.flushBuffer();
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        this.out.close();
    }

    protected static interface AMF3Writer {
        public void write(AMF3Serializer var1, Object var2) throws IOException;
    }
}

