/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.granite.clustering.DistributedData;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.tide.data.DataDispatcher;
import org.granite.tide.data.DataObserveParams;
import org.granite.tide.data.DataPublishParams;
import org.granite.tide.data.DataTopicParams;

public abstract class AbstractDataDispatcher
implements DataDispatcher {
    private static final Logger log = Logger.getLogger(AbstractDataDispatcher.class);
    protected boolean enabled;
    protected String topicName = null;
    protected DataTopicParams paramsProvider = null;
    protected String sessionId = null;
    protected String clientId = null;
    protected String subscriptionId = null;

    public AbstractDataDispatcher(String topicName, Class<? extends DataTopicParams> dataTopicParamsClass) {
        this.topicName = topicName;
        try {
            this.paramsProvider = dataTopicParamsClass.newInstance();
        }
        catch (Exception e) {
            log.error("Could not instantiate class " + dataTopicParamsClass, e);
        }
    }

    @Override
    public void observe() {
        GraniteContext graniteContext;
        DataObserveParams params = null;
        if (this.paramsProvider != null) {
            params = new DataObserveParams();
            this.paramsProvider.observes(params);
        }
        if ((graniteContext = GraniteContext.getCurrentInstance()) == null) {
            return;
        }
        DistributedData gdd = ((GraniteConfig)graniteContext.getGraniteConfig()).getDistributedDataFactory().getInstance();
        if (gdd == null) {
            return;
        }
        List<DataObserveParams> selectors = DataObserveParams.fromSerializableForm(gdd.getDestinationDataSelectors(this.topicName));
        ArrayList<DataObserveParams> newSelectors = new ArrayList<DataObserveParams>(selectors);
        boolean dataSelectorChanged = false;
        String dataSelector = gdd.getDestinationSelector(this.topicName);
        if (params != null) {
            String newDataSelector = params.updateDataSelector(dataSelector, newSelectors);
            boolean bl = dataSelectorChanged = !newDataSelector.equals(dataSelector);
            if (dataSelectorChanged) {
                log.debug("Data selector changed: %s", newDataSelector);
                gdd.setDestinationSelector(this.topicName, newDataSelector);
                dataSelector = newDataSelector;
            }
        }
        if (!DataObserveParams.containsSame(selectors, newSelectors)) {
            log.debug("Selectors changed: %s", newSelectors);
            gdd.setDestinationDataSelectors(this.topicName, DataObserveParams.toSerializableForm(newSelectors));
        }
        if (!this.enabled) {
            return;
        }
        if (dataSelectorChanged) {
            this.changeDataSelector(dataSelector);
        }
    }

    protected abstract void changeDataSelector(String var1);

    @Override
    public void publish(Object[][] dataUpdates) {
        if (!this.enabled) {
            return;
        }
        try {
            HashMap<Map<String, Object>, ArrayList<Object[]>> updates = new HashMap<Map<String, Object>, ArrayList<Object[]>>();
            if (this.paramsProvider != null) {
                for (Object[] dataUpdate : dataUpdates) {
                    DataPublishParams params = new DataPublishParams();
                    this.paramsProvider.publishes(params, dataUpdate[1]);
                    Map<String, Object> headers = params.getHeaders();
                    ArrayList<Object[]> list = (ArrayList<Object[]>)updates.get(headers);
                    if (list == null) {
                        list = new ArrayList<Object[]>();
                        updates.put(headers, list);
                    }
                    list.add(dataUpdate);
                }
            }
            for (Map.Entry me : updates.entrySet()) {
                HashMap<String, Object> headers = new HashMap<String, Object>((Map)me.getKey());
                headers.put("DSSubtopic", "tideDataTopic");
                headers.put("GDSSessionID", this.sessionId);
                headers.put("type", "DATA");
                this.publishUpdate(headers, ((List)me.getValue()).toArray());
            }
        }
        catch (Exception e) {
            log.error(e, "Could not publish data update on topic %s", this.topicName);
        }
    }

    protected abstract void publishUpdate(Map<String, Object> var1, Object var2);
}

