/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.config.api.GraniteConfigException;
import org.granite.messaging.service.tide.TideComponentAnnotatedWithMatcher;
import org.granite.messaging.service.tide.TideComponentInstanceOfMatcher;
import org.granite.messaging.service.tide.TideComponentMatcher;
import org.granite.messaging.service.tide.TideComponentNameMatcher;
import org.granite.messaging.service.tide.TideComponentTypeMatcher;

public class TideComponentMatcherFactory {
    public TideComponentMatcher getTypeMatcher(String type, boolean disabled) throws GraniteConfigException {
        try {
            return new TideComponentTypeMatcher(type, disabled);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not instantiate Tide component matcher for type: " + type, e);
        }
    }

    public TideComponentMatcher getNameMatcher(String name, boolean disabled) throws GraniteConfigException {
        try {
            return new TideComponentNameMatcher(name, disabled);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not instantiate Tide component matcher for name: " + name, e);
        }
    }

    public TideComponentMatcher getInstanceOfMatcher(String type, boolean disabled) throws GraniteConfigException {
        try {
            return new TideComponentInstanceOfMatcher(type, disabled);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not instantiate Tide component matcher for instance of: " + type, e);
        }
    }

    public TideComponentMatcher getAnnotatedWithMatcher(String type, boolean disabled) throws GraniteConfigException {
        try {
            return new TideComponentAnnotatedWithMatcher(type, disabled);
        }
        catch (Exception e) {
            throw new GraniteConfigException("Could not instantiate Tide component matcher for annotated with: " + type, e);
        }
    }

    public static boolean isComponentTideEnabled(Map<String, Object[]> tideComponentsByName, List<TideComponentMatcher> tideComponentMatchers, String componentName, Set<Class<?>> componentClasses, Object componentInstance) throws GraniteConfigException {
        String key;
        String string = key = componentName != null ? componentName : componentClasses.toString();
        if (tideComponentsByName.containsKey(key) && ((Integer)tideComponentsByName.get(key)[1]).intValue() == componentClasses.hashCode()) {
            return (Boolean)tideComponentsByName.get(key)[0];
        }
        boolean enabled = false;
        for (TideComponentMatcher matcher : tideComponentMatchers) {
            if (!matcher.matches(componentName, componentClasses, componentInstance, false)) continue;
            enabled = true;
            break;
        }
        tideComponentsByName.put(key, new Object[]{enabled, componentClasses.hashCode()});
        return enabled;
    }

    public static boolean isComponentTideDisabled(Map<String, Object[]> tideComponentsByName, List<TideComponentMatcher> tideComponentMatchers, String componentName, Set<Class<?>> componentClasses, Object componentInstance) throws GraniteConfigException {
        String key;
        String string = key = componentName != null ? componentName : componentClasses.toString();
        if (tideComponentsByName.containsKey(key) && ((Integer)tideComponentsByName.get(key)[1]).intValue() == componentClasses.hashCode()) {
            return (Boolean)tideComponentsByName.get(key)[0];
        }
        boolean disabled = false;
        for (TideComponentMatcher matcher : tideComponentMatchers) {
            if (!matcher.matches(componentName, componentClasses, componentInstance, true)) continue;
            disabled = true;
            break;
        }
        tideComponentsByName.put(key, new Object[]{disabled, componentClasses.hashCode()});
        return disabled;
    }
}

