/*
 * Decompiled with CFR 0.152.
 */
package org.granite.context;

import java.util.Map;
import org.granite.context.AMFContext;
import org.granite.context.AMFContextImpl;

public abstract class GraniteContext {
    public static final String SESSION_LAST_ACCESSED_TIME_KEY = "org.granite.session.lastAccessedTime";
    private static ThreadLocal<GraniteContext> instance = new ThreadLocal<GraniteContext>(){

        @Override
        protected GraniteContext initialValue() {
            return null;
        }
    };
    private final Object graniteConfig;
    private final Object servicesConfig;
    private final AMFContext amfContext;
    private final String sessionId;
    private final String clientType;

    public GraniteContext(Object graniteConfig, Object servicesConfig, String sessionId) {
        this(graniteConfig, servicesConfig, sessionId, null);
    }

    public GraniteContext(Object graniteConfig, Object servicesConfig, String sessionId, String clientType) {
        this.servicesConfig = servicesConfig;
        this.graniteConfig = graniteConfig;
        this.amfContext = new AMFContextImpl();
        this.sessionId = sessionId;
        this.clientType = clientType != null ? clientType : "as3";
    }

    public static GraniteContext getCurrentInstance() {
        return instance.get();
    }

    protected static void setCurrentInstance(GraniteContext context) {
        instance.set(context);
    }

    public static void release() {
        instance.set(null);
    }

    public <C> C getServicesConfig() {
        return (C)this.servicesConfig;
    }

    public <C> C getGraniteConfig() {
        return (C)this.graniteConfig;
    }

    public AMFContext getAMFContext() {
        return this.amfContext;
    }

    public String getClientType() {
        return this.clientType;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public abstract Object getSessionLock();

    public abstract Map<String, String> getInitialisationMap();

    public abstract Map<String, Object> getApplicationMap();

    public abstract Map<String, Object> getSessionMap();

    public abstract Map<String, Object> getSessionMap(boolean var1);

    public abstract Map<String, Object> getRequestMap();
}

