/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.granite.messaging.amf.io.util.FieldProperty;
import org.granite.messaging.amf.io.util.JavaClassDescriptor;
import org.granite.messaging.amf.io.util.MethodProperty;
import org.granite.messaging.amf.io.util.Property;
import org.granite.util.Introspector;
import org.granite.util.PropertyDescriptor;

public class DefaultGroovyClassDescriptor
extends JavaClassDescriptor {
    public DefaultGroovyClassDescriptor(Class<?> type) {
        super(type);
    }

    @Override
    protected List<Property> introspectProperties() {
        ArrayList<Property> properties = null;
        Class<?> type = this.getType();
        if (!(this.isExternalizable() || Map.class.isAssignableFrom(type) || Hashtable.class.isAssignableFrom(type))) {
            properties = new ArrayList<Property>();
            try {
                Field[] fields;
                PropertyDescriptor[] descs;
                HashSet<String> propertyNames = new HashSet<String>();
                Introspector.flushFromCaches(type);
                for (PropertyDescriptor property : descs = Introspector.getPropertyDescriptors(type)) {
                    String propertyName = property.getName();
                    if (property.getWriteMethod() == null || property.getReadMethod() == null) continue;
                    properties.add(new MethodProperty(this.converters, propertyName, property.getWriteMethod(), property.getReadMethod()));
                    propertyNames.add(propertyName);
                }
                for (Field field : fields = type.getFields()) {
                    String propertyName = field.getName();
                    if (propertyNames.contains(propertyName) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                    properties.add(new FieldProperty(this.converters, field));
                    propertyNames.add(propertyName);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return properties;
    }
}

