/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.BigDecimalCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;
import org.granite.messaging.jmf.codec.std.impl.util.IntegerUtil;

public class BigDecimalCodecImpl
extends AbstractStandardCodec<BigDecimal>
implements BigDecimalCodec {
    protected static final int LENGTH_BYTE_COUNT_OFFSET = 6;

    @Override
    public int getObjectType() {
        return 27;
    }

    @Override
    public Class<?> getObjectClass() {
        return BigDecimal.class;
    }

    @Override
    public void encode(OutputContext ctx, BigDecimal v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        int scale = v.scale();
        byte[] magnitude = v.unscaledValue().toByteArray();
        int count = IntegerUtil.significantIntegerBytesCount0(magnitude.length);
        os.write(count << 6 | 0x1B);
        IntegerUtil.encodeInteger(ctx, magnitude.length, count);
        os.write(scale);
        os.write(magnitude);
    }

    @Override
    public BigDecimal decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        int magnitudeLength = IntegerUtil.decodeInteger(ctx, parameterizedJmfType >>> 6);
        int scale = ctx.safeRead();
        byte[] magnitude = new byte[magnitudeLength];
        ctx.safeReadFully(magnitude);
        BigDecimal v = new BigDecimal(new BigInteger(magnitude), scale);
        if (BigDecimal.ZERO.equals(v)) {
            v = BigDecimal.ZERO;
        } else if (BigDecimal.ONE.equals(v)) {
            v = BigDecimal.ONE;
        } else if (BigDecimal.TEN.equals(v)) {
            v = BigDecimal.TEN;
        }
        return v;
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 27) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        ctx.indentPrintLn(BigDecimal.class.getName() + ": " + this.decode(ctx, parameterizedJmfType));
    }
}

