/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.ClassCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;
import org.granite.messaging.jmf.codec.std.impl.util.ClassNameUtil;

public class ClassCodecImpl
extends AbstractStandardCodec<Object>
implements ClassCodec {
    @Override
    public int getObjectType() {
        return 121;
    }

    @Override
    public boolean canEncode(Object v) {
        return v instanceof Class;
    }

    @Override
    public void encode(OutputContext ctx, Object v) throws IOException, IllegalAccessException {
        String className = ((Class)v).getName();
        className = ctx.getAlias(className);
        ctx.getOutputStream().write(121);
        ClassNameUtil.encodeClassName(ctx, className);
    }

    @Override
    public Object decode(InputContext ctx, int parameterizedJmfType) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        String className = ClassNameUtil.decodeClassName(ctx);
        className = ctx.getAlias(className);
        return ctx.getReflection().loadClass(className);
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 121) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        String className = ClassNameUtil.decodeClassName(ctx);
        className = ctx.getAlias(className);
        ctx.indentPrintLn(Class.class.getName() + ": " + className + ".class");
    }
}

