/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl.util;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;

public class LongUtil {
    public static final long MIN_1_BYTES_VARIABLE_LONG = -64L;
    public static final long MAX_1_BYTES_VARIABLE_LONG = 63L;
    public static final long MIN_2_BYTES_VARIABLE_LONG = -8256L;
    public static final long MAX_2_BYTES_VARIABLE_LONG = 8255L;
    public static final long MIN_3_BYTES_VARIABLE_LONG = -1056832L;
    public static final long MAX_3_BYTES_VARIABLE_LONG = 1056831L;
    public static final long MIN_4_BYTES_VARIABLE_LONG = -135274560L;
    public static final long MAX_4_BYTES_VARIABLE_LONG = 135274559L;
    public static final long MIN_5_BYTES_VARIABLE_LONG = -17315143744L;
    public static final long MAX_5_BYTES_VARIABLE_LONG = 17315143743L;
    public static final long MIN_6_BYTES_VARIABLE_LONG = -2216338399296L;
    public static final long MAX_6_BYTES_VARIABLE_LONG = 2216338399295L;
    public static final long MIN_7_BYTES_VARIABLE_LONG = -283691315109952L;
    public static final long MAX_7_BYTES_VARIABLE_LONG = 283691315109951L;
    public static final long MIN_8_BYTES_VARIABLE_LONG = -36312488334073920L;
    public static final long MAX_8_BYTES_VARIABLE_LONG = 36312488334073919L;

    public static void encodeLong(OutputContext ctx, long v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        os.write((int)(v >>> 56));
        os.write((int)(v >>> 48));
        os.write((int)(v >>> 40));
        os.write((int)(v >>> 32));
        os.write((int)(v >>> 24));
        os.write((int)(v >>> 16));
        os.write((int)(v >>> 8));
        os.write((int)v);
    }

    public static long decodeLong(InputContext ctx) throws IOException {
        return ctx.safeReadLong() << 56 | ctx.safeReadLong() << 48 | ctx.safeReadLong() << 40 | ctx.safeReadLong() << 32 | ctx.safeReadLong() << 24 | ctx.safeReadLong() << 16 | ctx.safeReadLong() << 8 | ctx.safeReadLong();
    }

    public static int significantLongBytesCount0(long v) {
        if (v < 0L) {
            return 7;
        }
        if (v <= 0xFFFFFFFFL) {
            if (v <= 65535L) {
                return v <= 255L ? 0 : 1;
            }
            return v <= 0xFFFFFFL ? 2 : 3;
        }
        if (v <= 0xFFFFFFFFFFFFL) {
            return v <= 0xFFFFFFFFFFL ? 4 : 5;
        }
        return v <= 0xFFFFFFFFFFFFFFL ? 6 : 7;
    }

    public static void encodeLong(OutputContext ctx, long v, int significantLongBytesCount0) throws IOException {
        OutputStream os = ctx.getOutputStream();
        switch (significantLongBytesCount0) {
            case 7: {
                os.write((int)(v >>> 56));
            }
            case 6: {
                os.write((int)(v >>> 48));
            }
            case 5: {
                os.write((int)(v >>> 40));
            }
            case 4: {
                os.write((int)(v >>> 32));
            }
            case 3: {
                os.write((int)(v >>> 24));
            }
            case 2: {
                os.write((int)(v >>> 16));
            }
            case 1: {
                os.write((int)(v >>> 8));
            }
            case 0: {
                os.write((int)v);
            }
        }
    }

    public static long decodeLong(InputContext ctx, int significantLongBytesCount0) throws IOException {
        long v = 0L;
        switch (significantLongBytesCount0) {
            case 7: {
                v |= ctx.safeReadLong() << 56;
            }
            case 6: {
                v |= ctx.safeReadLong() << 48;
            }
            case 5: {
                v |= ctx.safeReadLong() << 40;
            }
            case 4: {
                v |= ctx.safeReadLong() << 32;
            }
            case 3: {
                v |= ctx.safeReadLong() << 24;
            }
            case 2: {
                v |= ctx.safeReadLong() << 16;
            }
            case 1: {
                v |= ctx.safeReadLong() << 8;
            }
            case 0: {
                v |= ctx.safeReadLong();
            }
        }
        return v;
    }

    public static void encodeVariableLong(OutputContext ctx, long v) throws IOException {
        LongUtil.encodeVariableUnsignedLong(ctx, v << 1 ^ v >> 63);
    }

    public static long decodeVariableLong(InputContext ctx) throws IOException {
        long v = LongUtil.decodeVariableUnsignedLong(ctx);
        return (v & 1L) == 0L ? v >>> 1 : 0xFFFFFFFFFFFFFFFFL ^ v >>> 1;
    }

    public static void encodeVariableUnsignedLong(OutputContext ctx, long v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        if (v >= 0L && v < 72624976668147840L) {
            if (v < 270549120L) {
                if (v < 16512L) {
                    if (v < 128L) {
                        os.write((int)v);
                    } else {
                        os.write(0x80 | (int)(v -= 128L));
                        os.write((int)(v >>> 7));
                    }
                } else if (v < 2113664L) {
                    os.write(0x80 | (int)(v -= 16512L));
                    os.write(0x80 | (int)(v >>> 7));
                    os.write((int)(v >>> 14));
                } else {
                    os.write(0x80 | (int)(v -= 2113664L));
                    os.write(0x80 | (int)(v >>> 7));
                    os.write(0x80 | (int)(v >>> 14));
                    os.write((int)(v >>> 21));
                }
            } else if (v < 4432676798592L) {
                if (v < 34630287488L) {
                    os.write(0x80 | (int)(v -= 270549120L));
                    os.write(0x80 | (int)(v >>> 7));
                    os.write(0x80 | (int)(v >>> 14));
                    os.write(0x80 | (int)(v >>> 21));
                    os.write((int)(v >>> 28));
                } else {
                    os.write(0x80 | (int)(v -= 34630287488L));
                    os.write(0x80 | (int)(v >>> 7));
                    os.write(0x80 | (int)(v >>> 14));
                    os.write(0x80 | (int)(v >>> 21));
                    os.write(0x80 | (int)(v >>> 28));
                    os.write((int)(v >>> 35));
                }
            } else if (v < 567382630219904L) {
                os.write(0x80 | (int)(v -= 4432676798592L));
                os.write(0x80 | (int)(v >>> 7));
                os.write(0x80 | (int)(v >>> 14));
                os.write(0x80 | (int)(v >>> 21));
                os.write(0x80 | (int)(v >>> 28));
                os.write(0x80 | (int)(v >>> 35));
                os.write((int)(v >>> 42));
            } else {
                os.write(0x80 | (int)(v -= 567382630219904L));
                os.write(0x80 | (int)(v >>> 7));
                os.write(0x80 | (int)(v >>> 14));
                os.write(0x80 | (int)(v >>> 21));
                os.write(0x80 | (int)(v >>> 28));
                os.write(0x80 | (int)(v >>> 35));
                os.write(0x80 | (int)(v >>> 42));
                os.write((int)(v >>> 49));
            }
        } else {
            os.write(0x80 | (int)v);
            os.write(0x80 | (int)(v >>> 7));
            os.write(0x80 | (int)(v >>> 14));
            os.write(0x80 | (int)(v >>> 21));
            os.write(0x80 | (int)(v >>> 28));
            os.write(0x80 | (int)(v >>> 35));
            os.write(0x80 | (int)(v >>> 42));
            os.write(0x80 | (int)(v >>> 49));
            os.write((int)(v >>> 56));
        }
    }

    public static long decodeVariableUnsignedLong(InputContext ctx) throws IOException {
        long v = ctx.safeReadLong();
        if ((v & 0x80L) != 0L) {
            v = ((v = v & 0x7FL | ctx.safeReadLong() << 7) & 0x4000L) != 0L ? (((v = v & 0x3FFFL | ctx.safeReadLong() << 14) & 0x200000L) != 0L ? (((v = v & 0x1FFFFFL | ctx.safeReadLong() << 21) & 0x10000000L) != 0L ? (((v = v & 0xFFFFFFFL | ctx.safeReadLong() << 28) & 0x800000000L) != 0L ? (((v = v & 0x7FFFFFFFFL | ctx.safeReadLong() << 35) & 0x40000000000L) != 0L ? (((v = v & 0x3FFFFFFFFFFL | ctx.safeReadLong() << 42) & 0x2000000000000L) != 0L ? (((v = v & 0x1FFFFFFFFFFFFL | ctx.safeReadLong() << 49) & 0x100000000000000L) != 0L ? v & 0xFFFFFFFFFFFFFFL | ctx.safeReadLong() << 56 : (v += 567382630219904L)) : (v += 4432676798592L)) : (v += 34630287488L)) : (v += 270549120L)) : (v += 2113664L)) : (v += 16512L)) : (v += 128L);
        }
        return v;
    }
}

