/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.persistence;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.granite.config.ConvertersConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.persistence.AbstractExternalizablePersistentCollection;
import org.granite.util.TypeUtil;

public class ExternalizablePersistentSet
extends AbstractExternalizablePersistentCollection {
    private static final long serialVersionUID = 1L;

    public ExternalizablePersistentSet() {
    }

    public ExternalizablePersistentSet(Set<?> content, boolean initialized, boolean dirty) {
        super(null, initialized, dirty);
        this.setContentFromSet(content);
    }

    public ExternalizablePersistentSet(Object[] content, boolean initialized, boolean dirty) {
        super(content, initialized, dirty);
    }

    public Set<?> getContentAsSet(Type target) {
        return this.getContentAsSet(target, null);
    }

    public Set<?> getContentAsSet(Type target, Comparator comparator) {
        AbstractSet set = null;
        if (this.content != null) {
            set = SortedSet.class.isAssignableFrom(TypeUtil.classOfType(target)) ? (comparator != null ? new TreeSet(comparator) : new TreeSet()) : new HashSet(this.content.length);
            ConvertersConfig config = (ConvertersConfig)GraniteContext.getCurrentInstance().getGraniteConfig();
            Converters converters = config.getConverters();
            Type[] typeArguments = null;
            if (target instanceof ParameterizedType) {
                typeArguments = ((ParameterizedType)target).getActualTypeArguments();
            }
            for (Object o : this.content) {
                if (typeArguments != null) {
                    set.add(converters.convert(o, typeArguments[0]));
                    continue;
                }
                set.add(o);
            }
        }
        return set;
    }

    public void setContentFromSet(Set<?> set) {
        this.content = set != null ? set.toArray() : null;
    }
}

