/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.granite.messaging.reflect.BypassConstructorAllocator;
import org.granite.messaging.reflect.ClassDescriptor;
import org.granite.messaging.reflect.FieldProperty;
import org.granite.messaging.reflect.MethodProperty;
import org.granite.messaging.reflect.NullProperty;
import org.granite.messaging.reflect.Property;
import org.granite.messaging.reflect.SimpleFieldProperty;
import org.granite.messaging.reflect.SimpleMethodProperty;
import org.granite.messaging.reflect.SunBypassConstructorAllocator;

public class Reflection {
    protected static final int STATIC_TRANSIENT_MASK = 136;
    protected static final int STATIC_PRIVATE_PROTECTED_MASK = 14;
    protected static final Property NULL_PROPERTY = new NullProperty();
    protected final ClassLoader classLoader;
    protected final BypassConstructorAllocator instanceFactory;
    protected final Comparator<Property> lexicalPropertyComparator;
    protected final ConcurrentMap<Class<?>, ClassDescriptor> descriptorCache;
    protected final ConcurrentMap<SinglePropertyKey, Property> singlePropertyCache;

    public Reflection(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public Reflection(ClassLoader classLoader, BypassConstructorAllocator instanceFactory) {
        this.classLoader = classLoader;
        if (instanceFactory != null) {
            this.instanceFactory = instanceFactory;
        } else {
            try {
                this.instanceFactory = new SunBypassConstructorAllocator();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate BypassConstructorAllocator", e);
            }
        }
        this.lexicalPropertyComparator = new Comparator<Property>(){

            @Override
            public int compare(Property p1, Property p2) {
                return p1.getName().compareTo(p2.getName());
            }
        };
        this.descriptorCache = new ConcurrentHashMap();
        this.singlePropertyCache = new ConcurrentHashMap<SinglePropertyKey, Property>();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
    }

    public BypassConstructorAllocator getInstanceFactory() {
        return this.instanceFactory;
    }

    public Comparator<Property> getLexicalPropertyComparator() {
        return this.lexicalPropertyComparator;
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(className);
    }

    public <T> T newInstance(Class<T> cls) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SecurityException, NoSuchMethodException {
        ClassDescriptor desc = (ClassDescriptor)this.descriptorCache.get(cls);
        if (desc != null) {
            return (T)desc.newInstance();
        }
        try {
            Constructor<T> constructor = cls.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return (T)this.instanceFactory.newInstantiator(cls).newInstance();
        }
    }

    public <T> T newInstance(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SecurityException, NoSuchMethodException {
        return (T)this.newInstance(this.loadClass(className));
    }

    public Property findSerializableProperty(Class<?> cls, String name) throws SecurityException {
        List<Property> properties = this.findSerializableProperties(cls);
        for (Property property : properties) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public ClassDescriptor getDescriptor(Class<?> cls) {
        ClassDescriptor previousDescriptor;
        if (cls == null || cls == Object.class || !this.isRegularClass(cls)) {
            return null;
        }
        ClassDescriptor descriptor = (ClassDescriptor)this.descriptorCache.get(cls);
        if (descriptor == null && (previousDescriptor = this.descriptorCache.putIfAbsent(cls, descriptor = new ClassDescriptor(this, cls))) != null) {
            descriptor = previousDescriptor;
        }
        return descriptor;
    }

    public List<Property> findSerializableProperties(Class<?> cls) throws SecurityException {
        ClassDescriptor descriptor = this.getDescriptor(cls);
        if (descriptor == null) {
            return Collections.emptyList();
        }
        return descriptor.getInheritedSerializableProperties();
    }

    protected FieldProperty newFieldProperty(Field field) {
        return new SimpleFieldProperty(field);
    }

    protected MethodProperty newMethodProperty(Method getter, Method setter, String name) {
        return new SimpleMethodProperty(getter, setter, name);
    }

    public boolean isRegularClass(Class<?> cls) {
        return cls != Class.class && !cls.isAnnotation() && !cls.isArray() && !cls.isEnum() && !cls.isInterface() && !cls.isPrimitive();
    }

    public Property findProperty(Class<?> cls, String name, Class<?> type) {
        NameTypePropertyKey key = new NameTypePropertyKey(cls, name, type);
        Property property = (Property)this.singlePropertyCache.get(key);
        if (property == null) {
            Property previous;
            Field field = null;
            for (Class<?> c = cls; c != null && c != Object.class; c = c.getSuperclass()) {
                try {
                    field = c.getDeclaredField(name);
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                if (field.getType() != type) continue;
                field.setAccessible(true);
                break;
            }
            if ((previous = this.singlePropertyCache.putIfAbsent(key, property = field == null ? NULL_PROPERTY : this.newFieldProperty(field))) != null) {
                property = previous;
            }
        }
        return property != NULL_PROPERTY ? property : null;
    }

    public Property findProperty(Class<?> cls, Class<? extends Annotation> annotationClass) {
        AnnotatedPropertyKey key = new AnnotatedPropertyKey(cls, annotationClass);
        Property property = (Property)this.singlePropertyCache.get(key);
        if (property == null) {
            Property previous;
            boolean searchFields = false;
            boolean searchMethods = false;
            if (!annotationClass.isAnnotationPresent(Target.class)) {
                searchMethods = true;
                searchFields = true;
            } else {
                Target target = annotationClass.getAnnotation(Target.class);
                for (ElementType targetType : target.value()) {
                    if (targetType == ElementType.FIELD) {
                        searchFields = true;
                        continue;
                    }
                    if (targetType != ElementType.METHOD) continue;
                    searchMethods = true;
                }
            }
            if (!searchFields && !searchMethods) {
                return null;
            }
            int modifierMask = 9;
            block7: for (Class<?> c = cls; c != null && c != Object.class; c = c.getSuperclass()) {
                if (searchMethods) {
                    for (Method method : c.getDeclaredMethods()) {
                        String name;
                        if ((method.getModifiers() & 9) != 1 || !method.isAnnotationPresent(annotationClass)) continue;
                        if (method.getReturnType() == Void.TYPE) {
                            if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || (name = method.getName().substring(3)).length() == 0) continue;
                            Method getter = null;
                            try {
                                getter = cls.getMethod("get" + name, new Class[0]);
                            }
                            catch (NoSuchMethodException e) {
                                try {
                                    getter = cls.getMethod("is" + name, new Class[0]);
                                }
                                catch (Exception f) {
                                    // empty catch block
                                }
                            }
                            if (getter != null && (getter.getModifiers() & 8) != 0 && getter.getReturnType() != method.getParameterTypes()[0]) {
                                getter = null;
                            }
                            if (getter == null) continue;
                            name = name.substring(0, 1).toLowerCase() + name.substring(1);
                            property = this.newMethodProperty(getter, method, name);
                            break block7;
                        }
                        if (method.getParameterTypes().length != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is") || (name = method.getName().startsWith("get") ? method.getName().substring(3) : method.getName().substring(2)).length() == 0) continue;
                        Method setter = null;
                        try {
                            setter = cls.getMethod("set" + name, new Class[0]);
                        }
                        catch (NoSuchMethodException e) {
                            // empty catch block
                        }
                        if (setter != null && (setter.getModifiers() & 8) != 0 && method.getReturnType() != setter.getParameterTypes()[0]) {
                            setter = null;
                        }
                        name = name.substring(0, 1).toLowerCase() + name.substring(1);
                        property = this.newMethodProperty(method, setter, name);
                        break block7;
                    }
                }
                if (!searchFields) continue;
                for (Field field : c.getDeclaredFields()) {
                    if ((field.getModifiers() & 8) != 0 || !field.isAnnotationPresent(annotationClass)) continue;
                    property = this.newFieldProperty(field);
                    break block7;
                }
            }
            if (property == null) {
                property = NULL_PROPERTY;
            }
            if ((previous = this.singlePropertyCache.putIfAbsent(key, property)) != null) {
                property = previous;
            }
        }
        return property != NULL_PROPERTY ? property : null;
    }

    protected static class NameTypePropertyKey
    extends SinglePropertyKey {
        private final String name;
        private final Class<?> type;

        public NameTypePropertyKey(Class<?> cls, String name, Class<?> type) {
            super(cls);
            this.name = name;
            this.type = type;
        }

        public Class<?> getCls() {
            return this.cls;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public int hashCode() {
            return 31 * (31 * this.cls.hashCode()) + this.name.hashCode() + this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NameTypePropertyKey)) {
                return false;
            }
            NameTypePropertyKey key = (NameTypePropertyKey)obj;
            return this.cls.equals(key.cls) && this.name.equals(key.name) && this.type.equals(key.type);
        }
    }

    protected static class AnnotatedPropertyKey
    extends SinglePropertyKey {
        private final Class<? extends Annotation> annotationClass;

        public AnnotatedPropertyKey(Class<?> cls, Class<? extends Annotation> annotationClass) {
            super(cls);
            this.annotationClass = annotationClass;
        }

        public Class<?> getCls() {
            return this.cls;
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }

        public int hashCode() {
            return 31 * this.cls.hashCode() + this.annotationClass.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AnnotatedPropertyKey)) {
                return false;
            }
            AnnotatedPropertyKey key = (AnnotatedPropertyKey)obj;
            return this.cls.equals(key.cls) && this.annotationClass.equals(key.annotationClass);
        }
    }

    protected static abstract class SinglePropertyKey {
        protected final Class<?> cls;

        public SinglePropertyKey(Class<?> cls) {
            this.cls = cls;
        }
    }
}

